/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "button.h"

static int indices[255];
static unsigned int sample, flag, pick, pointer[2];
static int references;

@implementation Button

-(Button *) init
{
    int i;
    
    self = [super init];

    for (i = 1 ; i < 255 && indices[i] ; i += 1);
    indices[i] = 1;

    self->index = i;    
    
    return self;
}

-(void) toggle
{
    [super toggle];

    if ([self linked]) {
	if (references == 0) {
	    glEnable (GL_STENCIL_TEST);
	}
	
	references += 1;
    } else {
	if (references == 1) {
	    glDisable (GL_STENCIL_TEST);
	}
	
	references -= 1;
    }
}

-(void) free
{
    indices[self->index] = 0;

    [super free];
}

-(void) input
{
    GdkEvent *event;

    event = gdk_event_get ();
    assert (event);

    if (event->type == GDK_MOTION_NOTIFY) {
	pick = ((GdkEventMotion *)event)->state >> 8 == 0;
	pointer[0] = (int)(((GdkEventMotion *)event)->x);
	pointer[1] = (int)(((GdkEventMotion *)event)->y);
    }

    /* Put the event back for others to see. */
	
    gdk_event_put (event);
    gdk_event_free (event);    
	
    [super input];
}

-(void) traversePass: (int)pass
{
    if (pass == 1) {
	glStencilFunc (GL_ALWAYS, self->index, ~0);
	glStencilOp (GL_KEEP, GL_KEEP, GL_REPLACE);
    
	[super traversePass: pass];

	glStencilFunc (GL_ALWAYS, 0, ~0);
    } else {    
	[super traversePass: pass];
    }
}

-(void) prepare
{
    if (!flag) {
	flag = !flag;
    }

    [super prepare];
}

-(void) finish
{
    id child;
    
    /* Resample the stencil buffer if necessary.
       This has to be done during cleanup when
       the scene has been drawn but not cleared. */

    if (flag) {
	if (pick) {
	    int viewport[4];

	    glGetIntegerv (GL_VIEWPORT, viewport);
	    glReadPixels (pointer[0], viewport[3] - pointer[1], 1, 1,
	    		  GL_STENCIL_INDEX,
	    		  GL_UNSIGNED_INT, &sample);

	    pick = 0;
	}
	
	flag = !flag;
    }

    /* If this node has no other children apart
       from self->selected then there's no geometry
       to selecte so assume its index is 0 which
       basically means "everything else". */
    
    for (child = [self children];
	 child && child == self->selected;
	 child = [child sister]);

    if (child) {
	self->target = (sample == self->index);
    } else {
	self->target = (sample == 0);
    }
    
    [super finish];
}

@end
