/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include "array.h"

static void callhooks (lua_State *L, void *key, int reference, int index)
{
    if (reference != LUA_REFNIL) {
	lua_rawgeti(L, LUA_REGISTRYINDEX, reference);
	
	if (lua_isfunction (L, -1)) {
	    lua_getfield (L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (L, key);
	    lua_gettable (L, -2);
	    lua_replace (L, -2);
	    lua_pushnumber (L, index);
	    luaX_call(L, 2, 0);
	} else if (lua_istable (L, -1)) {
	    int i, n;
	    
	    n = lua_objlen (L, -1);

	    lua_getfield (L, LUA_REGISTRYINDEX, "userdata");

	    for (i = 0 ; i < n ; i += 1) {
		lua_rawgeti (L, -2, i + 1);

		lua_pushlightuserdata (L, key);
		lua_gettable (L, -3);
		lua_pushnumber (L, index);
		luaX_call (L, 2, 0);
	    }
	    
	    lua_pop (L, 2);
	} else {
	    lua_pop (L, 1);
	}
    }
}

@implementation Array

-(Array *) init
{
    char *list[] = {"mold", "size", "spawn"};
    
    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->mold = LUA_REFNIL;    
    self->spawn = LUA_REFNIL;    
    self->size = 0;
    
    return self;
}

-(void) spawn: (int)m through: (int)n
{
    int i;

    if (self->mold != LUA_REFNIL && n > m) {
	/* Get a hold of yourself. */
    
	lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	lua_pushlightuserdata (_L, self);
	lua_gettable (_L, -2);

	/* And start spawning. */
	
	for (i = m ; i < n ; i += 1) {
	    lua_pushnumber (_L, i + 1);
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->mold);
	    lua_newtable (_L);
	    luaX_call (_L, 1, 1);
	    lua_settable (_L, -3);

	    if (self->spawn != LUA_REFNIL) {
		callhooks (_L, self, self->spawn, i + 1);
	    }
	}

	lua_pop (_L, 2);
    }
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "size")) {
        lua_pushnumber (_L, self->size);
    } else if (!xstrcmp(k, "spawn")) {
        lua_rawgeti (_L, LUA_REGISTRYINDEX, self->spawn);
    } else if (!xstrcmp(k, "mold")) {
        lua_rawgeti (_L, LUA_REGISTRYINDEX, self->mold);
    } else  {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "size")) {
	int oldsize = self->size;

	self->size = lua_tonumber (_L, 3);
        [self spawn: oldsize through: self->size];
    } else if (!xstrcmp(k, "spawn")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->spawn);
        self->spawn = luaL_ref (_L, LUA_REGISTRYINDEX);
    } else if (!xstrcmp(k, "mold")) {
	luaL_unref (_L, LUA_REGISTRYINDEX, self->mold);
        self->mold = luaL_ref (_L, LUA_REGISTRYINDEX);

        [self spawn: 0 through: self->size];
    } else {
	[super set];	
    }
}

@end
