-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "meshes"
require "widgets"
require "textures"
require "dynamics"
require "aviation"
require "flexible"
require "accoustics"
require "nature"
require "imaging"

resources = {}

local function resolve (name)
   local file

   if options.prefix then
      local list

      if type (options.prefix) == "string" then
	 list = {options.prefix}
      else
	 list = options.prefix
      end

      for _, prefix in ipairs (list) do
	 file = io.open (prefix .. "/" .. name)

	 if file then
	    io.close (file)

	    return prefix .. "/" .. name
	 end
      end
   end

   return name
end

local function nomips (texture)
   texture.levels = {0, 2}
   return texture
end

local function filter (processor)
   return function (...)
	     local values = {...}
			       
	     return function (name)
		       local image
					 
		       image = resources.dofile(name)
		       image.pixels = processor (image.pixels,
						 image.size[1],
						 image.size[2],
						 unpack(values))
		       return image
		    end
	  end
end

function resources.readfile (name)
   print ("  " .. name)

   return io.open (resolve(name)):read "*a"
end

function resources.loadfile (name)
   print ("  " .. name)

   return loadfile(resolve(name))
end

function resources.dofile (name)
   print ("  " .. name)

   return assert(loadfile(resolve(name)))()
end

function resources.uncached (pipeline)
   return function (value)
	     local product = value
	     
	     for _, process in ipairs(pipeline) do
		product = process (product)
	     end
	     
	     return product
	  end
end

function resources.pipeline (pipeline)
   local cache = {}

   return function (value)
	     if cache[value] then
		return cache[value]
	     else
		local product = value

		for _, process in ipairs(pipeline) do
		   product = process (product)
		end

		cache[value] = product
	     
		return product
	     end
	  end
end

resources.basemips = resources.pipeline {resources.dofile, nomips, textures.mirrored}
resources.clamped = resources.pipeline {resources.dofile, textures.clamped}
resources.periodic = resources.pipeline {resources.dofile, textures.periodic}
resources.mirrored = resources.pipeline {resources.dofile, textures.mirrored}
resources.static = resources.pipeline {resources.dofile, meshes.static}
resources.polyhedron = resources.pipeline {resources.dofile, bodies.polyhedron}
resources.elevation = resources.pipeline {resources.dofile, nature.elevation}
resources.airplane = resources.pipeline {resources.dofile, aircraft.airplane}
resources.fabric = resources.pipeline {resources.dofile, flexible.fabric}
resources.sample = resources.pipeline {resources.dofile, sources.sample}
resources.loop = resources.pipeline {resources.dofile, sources.loop}

for key, value in pairs (imaging) do
   resources[key] = filter (value)
end
