-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "frames"

arrays = {}

function arrays.linear (values)
   local meta, self, oldindex, oldnewindex

   self = frames.array {
      spawn = function (self, i)
		 local spacing

		 meta = getmetatable(self)
		 spacing = meta.spacing or meta.length / self.size
		 if (self[i]) then
		    self[i].position = {spacing * (i - 1), 0, 0}
		 end
	      end
   }

   meta = getmetatable (self)
   meta.length = 1
   meta.spacing = 1
   meta.core = nil

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "length" then
			return meta.length or (meta.spacing * self.size)
		     elseif key == "spacing" then
			return meta.spacing or (meta.length / self.size)
		     elseif key == "spawn" then
			if meta.core then
			   return meta.core
			else
			   return oldindex (self, key)
			end
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "length" then
	 meta.length = value
	 meta.spacing = nil

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      elseif key == "spacing" then
	 meta.spacing = value
	 meta.length = nil

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      elseif key == "size" then
	 oldnewindex(self, key, value)

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      elseif key == "spawn" then
	 local wrap, core

	 core = oldindex (self, key)
	 wrap = function (self, i)
		   core (self, i)
		   value (self, i)
		end

	 meta.core = core

	 oldnewindex(self, key, wrap)
      else
	 oldnewindex(self, key, value)
      end
   end

   meta.__tostring = function(self)
			 return "linear"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end

