-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "frames"
require "widgets"
require "morewidgets"

local key = {}

graph[key] = widgets.display {
   align = {-1, -1},

   row = widgets.row {}
}

if type (options.profile) ~= "table" then
   options.profile = {options.profile}
end

if type (options.profilinglog) == "string" then
   graph[key].logger = frames.timer {
      period = options.profilingrate and 0.5 / options.profilingrate or 0.5,
      
      tick = function (self, tick, delta, elapsed)
      		if tick == 1 then
      		   self.period = self.period * 2
      		else
      		   self.file[1]:write (string.format ("%.3f, ", elapsed - 0.5 * self.period))

      		   for i = 1, #options.profile do
      		      self.file[1]:write (string.format ("%.3f, ", self.parent.row[i][1].reading))
      		   end

		   self.file[1]:write ("\n")
      		end
      	     end,
      
      link = function(self)
		self.file = {io.open (options.profilinglog, "w")}
	     end,

      unlink = function(self)
		  io.close(self.file[1])
	       end,
   }
end

for i, value in ipairs (options.profile) do
   local sampler

   sampler = loadstring ("return " .. value)

   if not sampler then
      sampler = function ()
   		   return 0
   		end
   end

   graph[key].row[i] = widgets.column {
      [1] = widgets.clock {
	 padding = {0.01, 0.01},
	 color = {1.0, 0.8, 0.2},
	 opacity = 0.6,
	 
	 radius = {0.07, 0.045},
	 range = {0, 240},
	 spacing = {5, 4},
	 spread = {-4 * math.pi / 5, 4 * math.pi / 5},

	 markings = frames.transform {
	    [1] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">0</span>]]
	    },

	    [2] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">20</span>]]
	    },

	    [3] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">40</span>]]
	    },

	    [4] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">60</span>]]
	    },

	    [5] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">80</span>]]
	    },

	    [7] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">120</span>]]
	    },

	    [9] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">160</span>]]
	    },

	    [11] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">200</span>]]
	    },

	    [13] = widgets.layout {
	       text = [[<span font="Sans 6" color="White">240</span>]]
	    },
	 },

	 hands = frames.transform {
	    [1] = shapes.line {
	       color = {1.0, 0.8, 0.2},

	       [1] = {0, -0.1},
	       [2] = {0, 0.75},
	       [3] = {0.05, 0},
	       [4] = {0, -0.1},
	       [5] = {-0.05, 0},
	       [6] = {0, 0.75},
	    },
	 },
      },

      [2] = widgets.layout {
	 width = 70,
	 text = [[<span font="Sans 7" color="White">]] .. value .. [[</span>]]
      },
    
      [3] = widgets.frame {
	 color = {1.0, 0.8, 0.2},
	 opacity = 0.5,

	 layout = widgets.layout {
	    padding = {0.01, 0.007},

	    timer = frames.timer {
	       period = options.profilingrate and
		           1 / options.profilingrate or
		           1,

	       sum = 0,
	       samples = 0,

	       finish = function (self)
			   self.sum = self.sum + sampler()
			   self.samples = self.samples + 1
			end,

	       tick = function (self, tick, delta, elapsed)
			 local mean

			 if self.samples > 0 then
			    mean = 1000 * self.sum / self.samples
			    self.ancestry[3][1].reading = mean
			    self.parent.text = string.format ([[<span font="Sans 9" color="White">%.1f ms</span>]], mean)
			 end

			 self.sum = 0
			 self.samples = 0
		      end
	    },
	 }
      },
   }
end

profiling.derived =
   setmetatable({}, {
		   __index = function (self, key)
				if key == "simulate" then
				   return profiling.iteration.collide +
				          profiling.iteration.step +
				          profiling.iteration.integrate +
				          profiling.iteration.transform
				elseif key == "iterate" then
				   return profiling.iteration.input +
				          profiling.iteration.begin +
				          profiling.iteration.prepare +
					  profiling.iteration.traverse[1] +
					  profiling.iteration.traverse[2] +
					  profiling.iteration.finish
				end
			     end,

		   __newindex = function (self, key)
				   if key == "framerate" then
				   end
				end,
		})
