-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local frustum

local function calculate ()
   local tantheta = math.tan(math.rad(0.5 * frustum[1]))
   local a = graphics.window and (graphics.window[1] / graphics.window[2]) or 1
   local n, f = frustum[2], frustum[3]
		       
   return {-a * n * tantheta,
	   a * n * tantheta,
	      -n * tantheta,
	   n * tantheta,
	   n, f}
end

derived = setmetatable ({}, {
		 __index = function (table, key)
		    if key == "frustum" then
		       return frustum
		    elseif key == "field" then
		       return frustum and frustum[1]
		    elseif key == "range" then
		       return frustum and {frustum[2], frustum[3]}
		    elseif key == "width" then
		       return graphics.window and graphics.window[1]
		    elseif key == "height" then
		       return graphics.window and graphics.window[2]
		    elseif key == "softness" then
		       return dynamics.tolerance[1]
		    elseif key == "stiffness" then
		       return dynamics.tolerance[2]
		    elseif key == "gee" then
		       return dynamics.gravity[3]
		    end
		 end,

		 __newindex = function (table, key, value)
                    if key == "frustum" then
		       frustum = value
		    elseif key == "field" then
		       if frustum then
			  frustum = {value, frustum[2], frustum[3]}
		       else
			  frustum = {value, 0.1, 1000}
		       end
		    elseif key == "range" then
		       if frustum then
			  frustum = {frustum[1], value[1], value[2]}
		       else
			  frustum = {45, value[1], value[2]}
		       end
		    elseif key == "width" then
		       if graphics.window then
			  graphics.window = {value, graphics.window[2]}
		       end
		    elseif key == "height" then
		       if graphics.window then
			  graphics.window = {graphics.window[1], value}
		       end
		    elseif key == "softness" then
		       dynamics.tolerance = {value, dynamics.tolerance[2]}
		    elseif key == "stiffness" then
		       dynamics.tolerance = {dynamics.tolerance[1], value}
		    elseif key == "gee" then
		       dynamics.gravity = {0, 0, value}
 		    end

		    if graphics.window and frustum ~= nil and
		       (key == "frustum" or
			key == "field" or
			key == "range" or
			key == "width" or
			key == "height") then
		       graphics.perspective = calculate ()
		    end
		 end
})

graphicsmeta = getmetatable (graphics)

if graphicsmeta ~= nil then
   local oldgraphicsnewindex = graphicsmeta.__newindex

   graphicsmeta.__newindex = function (table, key, value)
				oldgraphicsnewindex (table, key, value)

				if key == "window" and
				   frustum ~= nil and 
				   value ~= nil then
				   graphics.perspective = calculate ()
				end
			     end
end
