-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "meteorology"
require "units"

-- Air pressure wrt to height in sl/ft^2

atmosphere.pressure = {
   [units.feet (0.0000e+00)] = units.slugspersquarefeet (6.5774e+01), 
   [units.feet (3.6089e+03)] = units.slugspersquarefeet (5.7637e+01), 
   [units.feet (7.2178e+03)] = units.slugspersquarefeet (5.0335e+01), 
   [units.feet (1.0827e+04)] = units.slugspersquarefeet (4.3801e+01), 
   [units.feet (1.4436e+04)] = units.slugspersquarefeet (3.7971e+01), 
   [units.feet (1.8045e+04)] = units.slugspersquarefeet (3.2786e+01), 
   [units.feet (2.1654e+04)] = units.slugspersquarefeet (2.8190e+01), 
   [units.feet (2.5262e+04)] = units.slugspersquarefeet (2.4130e+01), 
   [units.feet (2.8871e+04)] = units.slugspersquarefeet (2.0557e+01), 
   [units.feet (3.2480e+04)] = units.slugspersquarefeet (1.7425e+01)
}

-- Air density wrt to height in sl/ft^3

atmosphere.density = {
   [units.feet (0.0000e+00)] = units.slugspercubicfeet (2.3769e-03), 
   [units.feet (3.6089e+03)] = units.slugspercubicfeet (2.1358e-03), 
   [units.feet (7.2178e+03)] = units.slugspercubicfeet (1.9140e-03), 
   [units.feet (1.0827e+04)] = units.slugspercubicfeet (1.7101e-03), 
   [units.feet (1.4436e+04)] = units.slugspercubicfeet (1.5234e-03), 
   [units.feet (1.8045e+04)] = units.slugspercubicfeet (1.3526e-03), 
   [units.feet (2.1654e+04)] = units.slugspercubicfeet (1.1969e-03), 
   [units.feet (2.5262e+04)] = units.slugspercubicfeet (1.0553e-03), 
   [units.feet (2.8871e+04)] = units.slugspercubicfeet (9.2687e-04), 
   [units.feet (3.2480e+04)] = units.slugspercubicfeet (8.1076e-04)
}
