/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "top.h"

@implementation Top

-(Top *) init
{
    self = [super init];
    
    self->axis[0] = 0;
    self->axis[1] = 0;
    self->axis[2] = 1;

    self->spin = 0;
    
    return self;
}

-(void) toggle
{
    struct timespec time;
    
    [super toggle];

    clock_gettime (CLOCK_REALTIME, &time);
    
    self->tick = time.tv_sec + time.tv_nsec / 1e9;
}
    
-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "axis")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->axis[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "spin")) {
	lua_pushnumber (_L, self->spin);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "axis")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->axis[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "spin")) {
	self->spin = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

-(void)transform
{
    struct timespec time;
    GLfloat T[16];
    double now;

    T[0] = self->orientation[0];
    T[1] = self->orientation[3];
    T[2] = self->orientation[6];
    T[3] = 0;	

    T[4] = self->orientation[1];
    T[5] = self->orientation[4];
    T[6] = self->orientation[7];
    T[7] = 0;	

    T[8] = self->orientation[2];
    T[9] = self->orientation[5];
    T[10] = self->orientation[8];
    T[11] = 0;	

    T[12] = 0;
    T[13] = 0;
    T[14] = 0;
    T[15] = 1;	
    
    clock_gettime (CLOCK_REALTIME, &time);
    now = time.tv_sec + time.tv_nsec / 1e9;
    
    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glLoadMatrixf(T);
    glRotatef(self->spin / M_PI * 180.0 * (now - self->tick),
	      self->axis[0],
	      self->axis[1],
	      self->axis[2]);
    glGetFloatv (GL_MODELVIEW_MATRIX, T);
    glPopMatrix();

    self->tick = now;

    self->orientation[0] = T[0];
    self->orientation[1] = T[4];
    self->orientation[2] = T[8];

    self->orientation[3] = T[1];
    self->orientation[4] = T[5];
    self->orientation[5] = T[9];

    self->orientation[6] = T[2];
    self->orientation[7] = T[6];
    self->orientation[8] = T[10];

    [super transform];
}

@end

