/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "lamp.h"
#include "shadow.h"

@implementation Shadow

-(void) traversePass: (int)pass
{
    if (pass == 1) {
	id parent, child;
		
	for (parent = [self parent]; parent; parent = [parent parent]) {
	    for (child = [parent children] ; child ; child = [child sister]) {
		if ([child isMemberOf: [Lamp class]]) {
		    GLfloat M[16], T[16], R[16];
		    GLfloat dot;

		    glMatrixMode(GL_MODELVIEW);
		    glGetFloatv (GL_MODELVIEW_MATRIX, R);
				    
		    glPushMatrix();
		    glMultMatrixf ([self homogenous]);
		    glGetFloatv (GL_MODELVIEW_MATRIX, M);
		    glPopMatrix();

		    glPushMatrix();
		    glMultMatrixf ([child homogenous]);
		    glGetFloatv (GL_MODELVIEW_MATRIX, T);
		    glPopMatrix();

		    dot = M[8] * (M[12] - T[12]) +
			  M[9] * (M[13] - T[13]) +
			  M[10] * (M[14] - T[14]);

		    glPushMatrix();
		    glLoadIdentity();
		    glTranslatef (T[12], T[13], T[14]);
		    glMultMatrixf ((GLfloat[16]){
			     -dot, 0, 0, -M[8],
				0, -dot, 0, -M[9],
				0, 0, -dot, -M[10],
				0, 0, 0, 0});
		    glTranslatef (-T[12], -T[13], -T[14]);
		    glMultMatrixf(R);

		    [super traversePass: pass];
		
		    glPopMatrix();
		}
	    }
	}
    } else {
	[super traversePass: pass];
    }
}

@end

