/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "pie.h"

@implementation Pie

-(Pie *) init
{
    [super init];
      
    self->radius = 1;
    self->arc = 2 * M_PI;
    self->segments = 16;
  
    return self;
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "radius")) {
	lua_pushnumber (_L, self->radius);
    } else if (!xstrcmp(k, "arc")) {
	lua_pushnumber (_L, self->arc);
    } else if (!xstrcmp(k, "segments")) {
	lua_pushnumber (_L, self->segments);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "radius")) {
	self->radius = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "arc")) {
	self->arc = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "segments")) {
	self->segments = lua_tonumber (_L, 3);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    int i;

    if (pass == 2) {
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glMultMatrixf ([self homogenous]);

	glUseProgramObjectARB(0);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_POLYGON_SMOOTH);
	glEnable(GL_BLEND);

	glColor4fv([self color]);
    
	glBegin (GL_TRIANGLE_FAN);

	glVertex2f(0, 0);

	for (i = 0 ; i <= self->segments ; i += 1) {
	    glVertex2f(self->radius * cos (i * self->arc / self->segments),
		       self->radius * sin (i * self->arc / self->segments));
	}
   
	glEnd();
    
	glDisable(GL_BLEND);
	glDisable(GL_POLYGON_SMOOTH);
	glDisable(GL_DEPTH_TEST);
    
	glPopMatrix();
    }
    
    [super traversePass: pass];
}

@end
