/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mustache.h"

@implementation Mustache

-(void) transform
{
    id parent;

    /* Temporarily disconnect the node from its
       parent to transform it as if it were the
       root. */
    
    parent = self->up;
    self->up = nil;

    [super transform];

    self->up = parent;
}

-(void) traversePass: (int)pass
{
    if (pass > 0) {    
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity ();

	[super traversePass: pass];

	glMatrixMode (GL_MODELVIEW);
	glPopMatrix();
    } else {
	[super traversePass: pass];
    }
}

@end
