/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "texture.h"
#include "lambert.h"
#include "light.h"

static GLuint name;
static const GLchar *vertexSource = 
"varying vec3 vertex, vertexNormal;   	     	     			\n"
"				   		     			\n"
"void main() 			   		     			\n"
"{		 		   		     			\n"
"    vec3 n;								\n"
"				   		     			\n"
"    vertex = vec3(gl_ModelViewMatrix * gl_Vertex);			\n"
"    vertexNormal = gl_NormalMatrix * gl_Normal;			\n"
"				   		     			\n"
"    gl_Position = ftransform();	     				\n"
"    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;	   	\n"
"}		 		   		     			\n";

static const GLchar *fragmentSource = 
"varying vec3 vertex, vertexNormal;   	     	     			\n"
"				   		     			\n"
"void main()                            	     			\n"
"{	                                	     			\n"
"    vec3 reflectance, normal, sum;					\n"
"    int i;								\n"
"			   		     				\n"
"    reflectance = vec3(diffuseSum(gl_TexCoord[0].st));			\n"
"				   		     		   	\n"
"    normal = normalize(vertexNormal);				   	\n"
"				   		     		   	\n"
"    for (i = 0, sum = vec3(0) ; i < lightCount ; i += 1) {	   	\n"
"    sum = vec3(0); \n"    
"    i = 0; \n"    
"        vec3 light;						   	\n"
"				   		     		   	\n"
"        light = normalize(lightSources[i].position - vertex);	   	\n"
"				   		     		   	\n"
"        sum += luminousIntensity(lightSources[i], light) *    	   	\n"
"               shadowFactor (lightSources[i], vertex) *	  	\n"
"               attenuationFactor (lightSources[i], vertex) *	   	\n"
"               max(dot(normal, light), 0.0) * reflectance;		\n"
"    }								   	\n"
"				   		     		   	\n"
"    sum += reflectance * ambientIntensity(normal);   	   	        \n"
"				   		     			\n"
"    gl_FragColor = vec4(befog (sum, vertex), 1.0);			\n"
"}                                      	     			\n";

@implementation Lambert

-(Lambert *)init
{
    if (!name) {
	[self build];
	[self verify];

	name = self->program;
    } else {
	self->program = name;
    }
    
    [super init];

    return self;
}

-(void) build
{
    [super build];
    
    [self attachVertexSource: vertexSource];
    [self attachFragmentSource: fragmentSource];
    [self link];
}
    
-(void) traversePass: (int)pass
{
    if (pass == 1) {
	glUseProgramObjectARB(self->program);
	glActiveTexture (GL_TEXTURE0);
    }
    
    [super traversePass: pass];
}

@end
