/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "joint.h"
#include "body.h"

@implementation Joint

-(dJointID) joint
{
    return self->joint;
}

-(void) free
{
    dJointDestroy (self->joint);
    
    [super free];
}

-(void) get
{
    const char *k;
    int i;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "bodies")) {
	lua_getmetatable (_L, -2);
	lua_replace (_L, -3);
	lua_gettable (_L, -2);
	    
	if (lua_isnil (_L, -1)) {
	    lua_newtable (_L);
	}
    } else if (!xstrcmp(k, "forces")) {
        lua_newtable (_L);

	/* The force applied on the first body. */
	
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->feedback.f1[i]);
            lua_rawseti (_L, -2, i + 1);
        }

	lua_rawseti (_L, -2, 1);

	/* The force applied on the second body. */
	
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->feedback.f2[i]);
            lua_rawseti (_L, -2, i + 1);
        }

	lua_rawseti (_L, -2, 2);
    } else if (!xstrcmp(k, "torques")) {
        lua_newtable (_L);

	/* The torque applied on the first body. */
	
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->feedback.t1[i]);
            lua_rawseti (_L, -2, i + 1);
        }

	lua_rawseti (_L, -2, 1);

	/* The torque applied on the second body. */
	
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->feedback.t2[i]);
            lua_rawseti (_L, -2, i + 1);
        }

	lua_rawseti (_L, -2, 2);	
    } else {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    }
}

-(void) set
{
    id a, b;
    const char *k;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "bodies")) {
	if(lua_istable (_L, 3)) {
	    lua_rawgeti (_L, 3, 1);
	    if(lua_isuserdata (_L, -1)) {
		a = (*(id *)lua_touserdata (_L, -1));
	    } else {
		a = nil;
	    }

	    lua_rawgeti (_L, 3, 2);
	    if(lua_isuserdata (_L, -1)) {
		b = (*(id *)lua_touserdata (_L, -1));
	    } else {
		b = nil;
	    }

	    lua_pop (_L, 2);
	    
	    lua_getmetatable (_L, 1);
	    lua_pushvalue (_L, 2);
	    lua_pushvalue (_L, 3);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	    
	    dJointAttach([self joint], [a body], [b body]);
	    dJointSetFeedback ([self joint], &self->feedback);
	} else {
	    dJointAttach([self joint], NULL, NULL);
	    dJointSetFeedback ([self joint], NULL);
	}	    
    } else {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_settable (_L, 1);
    }
}

@end
