/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ITEM_H_
#define _ITEM_H_

#include <lua.h>
#include <objc/Object.h>

@interface Item: Object {
    Item *left, *right, *up, *down;

    char *key;
}

-(id) parent;
-(id) children;
-(id) brother;
-(id) sister;
-(id) root;
-(char *) key;
-(void) adoptedBy: (Item *) parent;
-(void) adopt: (Item *)child named: (const char *)key;
-(void) renounce: (Item *)child;

@end

#endif
