/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "body.h"
#include "hooke.h"

@implementation Hooke

-(Hooke *) init
{
    self = [super init];
    
    self->stiffness = 0;
    self->damping = 0;
    self->length = 0;
    
    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "stiffness")) {
	lua_pushnumber (_L, self->stiffness);
    } else if (!xstrcmp(k, "damping")) {
	lua_pushnumber (_L, self->damping);
    } else if (!xstrcmp(k, "length")) {
	lua_pushnumber (_L, self->length);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "stiffness")) {
	self->stiffness = lua_tonumber (_L, -1);
    } else if (!xstrcmp(k, "damping")) {
	self->damping = lua_tonumber (_L, -1);
    } else if (!xstrcmp(k, "length")) {
	self->length = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

-(void)stepBy: (double)h
{
    id sibling;
    GLfloat *here;

    here = [self position];

    for (sibling = [[self parent] children] ;
	 sibling ;
	 sibling = [sibling sister]) {
	if ([sibling isKindOf: [Body class]] && [sibling body]) {
	    const dReal *there, *velocity;
	    dReal k;
	    
	    there = dBodyGetPosition([sibling body]);
	    velocity = dBodyGetLinearVel ([sibling body]);
	    k = 1 - self->length / sqrt ((there[0] - here[0]) *
					 (there[0] - here[0]) +
					 (there[1] - here[1]) *
					 (there[1] - here[1]) +
					 (there[2] - here[2]) *
					 (there[2] - here[2]));
	    
	    dBodyEnable ([sibling body]);
	    dBodyAddForce([sibling body],
			  -self->stiffness * k * (there[0] - here[0]) -
			  self->damping * velocity[0],
			  -self->stiffness * k * (there[1] - here[1]) -
			  self->damping * velocity[1],
			  -self->stiffness * k * (there[2] - here[2]) -
			  self->damping * velocity[2]);
	    
	}
    }
    
    [super stepBy: h];
}

@end

