/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "graph.h"
#include "paper.h"

@implementation Graph

-(Graph *)init
{
    [super init];

    self->points = NULL;
    self->size = 0;
    
    return self;
}

-(void) get
{
    int i, j;

    if (lua_isnumber (_L, 2)) {
	j = lua_tonumber (_L, 2) - 1;
	
	lua_newtable (_L);

        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->points[2 * j + i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{
    int i, j;

    if (lua_isnumber (_L, 2)) {
        if(lua_istable (_L, 3)) {
	    j = lua_tonumber (_L, 2);

	    if (j > self->size) {
		self->size = j;
		self->points = (GLfloat *)realloc (self->points,
						   3 * j * sizeof(GLfloat));
	    }

            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->points[2 * (j - 1) + i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else {
	[super set];
    }
}

-(void) transform
{
    self->minimum[0] = self->requested[0] - 2 * self->padding[0];
    self->minimum[1] = self->requested[1] - 2 * self->padding[1];

    self->allocated[0] = self->requested[0];
    self->allocated[1] = self->requested[1];

    [super transform];
}

-(void) traversePass: (int)pass
{
    int i;
    
    if (pass == 2) {
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glMultMatrixf ([self homogenous]);

	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glLineWidth (1);

	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_BLEND);

	glDepthMask (GL_FALSE);

	/* Draw the graph. */
    
	glColor4fv([self color]);

	glBegin(GL_LINE_STRIP);
	for (i = 0 ; i < self->size ; i += 1) {
	    glVertex2f ([[self parent] translateAbscissa: self->points[2 * i]],
			[[self parent] translateOrdinate: self->points[2 * i + 1]]);
	}
    
	glEnd();

	glDepthMask (GL_TRUE);

	glDisable (GL_BLEND);
	glDisable (GL_LINE_SMOOTH);
    
	glPopMatrix();
    }
    
    [super traversePass: pass];
}

@end
