-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "dynamics"
require "physics"
require "moremath"

function particulate.stream (values)
   local meta, self, oldindex, oldnewindex

   self = particulate.fluid {
      index = 0,
      
      step = function (self)
         local c, rho, sigma, alpha, tau, particle, piece
	 local V, phi, theta

	 if math.random() < meta.rate then
	    V = math.gaussian (meta.velocity[1], meta.velocity[2])
	    theta = math.gaussian (0, meta.velocity[3])
	    phi = 2 * math.pi * math.random ()

	    c = meta.color
	    rho = meta.radius
	    alpha = meta.albedo
	    tau = meta.opacity

	    particle = {
	       0, 0, 0,
	       
	       V * math.cos (phi) * math.sin (theta),
	       V * math.sin (phi) * math.sin (theta),
	       V * math.cos (theta),

	       c[1], c[2], c[3],
	       
	       rho[1], rho[2],
	       alpha[1], alpha[2],
	       tau[1], tau[2]	       
	    }
		   
	    self[self.index % self.size] = particle
	    self.index = self.index + 1
	 end
      end
   }

   meta = getmetatable (self)

   meta.emitters = {}
   meta.rate = 0
   meta.velocity = {1, 1, 0.1}
   meta.color = {1, 1, 1}
   meta.radius = {1, 1e-1}
   meta.albedo = {0.5, 1e-1}
   meta.opacity = {0.5, 1e-1}

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "emitters" or key == "rate" or
			key == "color" or key == "radius" or 
			key == "albedo" or key == "opacity" or 
			key == "velocity" then
			return meta[key]
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
			local meta = getmetatable(self)

			if key == "emitters" or key == "rate" or
			   key == "color" or key == "radius" or 
			   key == "albedo" or key == "opacity" or 
			   key == "velocity" then
			   meta[key] = value
			else
			   oldnewindex(self, key, value)
			end
		     end

   meta.__tostring = function(self)
			return "stream"
		     end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end

function particulate.trail (values)
   local self, meta, oldindex, oldnewindex

   self = particulate.stream {
      support = 0
   }

   meta = getmetatable (self)

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     if key == "stiffness" or key == "viscosity" then
			return oldindex (self, key)[2]
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
			if key == "stiffness" or key == "viscosity" then
			   oldnewindex (self, key, {0, value})
			else
			   oldnewindex(self, key, value)
			end
		     end

   meta.__tostring = function(self)
			return "trail"
		     end


   for key, value in pairs(values) do
      self[key] = value
   end

   return self   
end
