-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "dynamics"
require "physics"
require "moremath"

springs = {}

function springs.linear (values)
   local meta, self, oldindex, oldnewindex

   self = joints.slider {
   }

   meta = getmetatable (self)
   meta.stiffness = 100
   meta.damping = 10
   meta.preload = 0

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "stiffness" then
			return meta.stiffness
		     elseif key == "damping" then
			return meta.damping
		     elseif key == "preload" then
			return meta.preload
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "stiffness" then
	 meta.stiffness = value
      elseif key == "damping" then
	 meta.damping = value
      elseif key == "preload" then
	 meta.preload = value
      elseif key == "bodies" then
	 if value[1] and value[2] then
	    self.axis = math.normalize(math.subtract(value[1].position,
						     value[2].position))
	 end

	 oldnewindex(self, key, value)
      else
	 oldnewindex(self, key, value)
      end

      if key == "stiffness" or
	 key == "damping" or
	 key == "preload" or
	 key == "bodies" then
	 self.stops = {{meta.preload, meta.preload},
		       physics.spring (meta.stiffness, meta.damping),
		       0}
      end
   end

   meta.__tostring = function(self)
			 return "linear"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end

function springs.euler (values)
   local meta, self, oldindex, oldnewindex

   self = joints.spherical {
   }

   meta = getmetatable (self)
   meta.stiffness = {100, 100, 100}
   meta.damping = {10, 10, 10}
   meta.preload = {0, 0, 0}

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "stiffness" then
			return meta.stiffness
		     elseif key == "damping" then
			return meta.damping
		     elseif key == "preload" then
			return meta.preload
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "stiffness" then
	 
	 meta.stiffness = value
      elseif key == "damping" then
	 meta.damping = value
      elseif key == "preload" then
	 meta.preload = value
      else
	 oldnewindex(self, key, value)
      end

      if key == "stiffness" or
	 key == "damping" or
	 key == "preload" or
	 key == "bodies" then
	 local k_s = meta.stiffness
	 local k_d = meta.damping
	 local delta = meta.preload

	 if type(k_s) == "number" then
	    k_s = {k_s, k_s, k_s}
	 end

	 if type(k_d) == "number" then
	    k_d = {k_d, k_d, k_d}
	 end

	 self.stops = {
	    {{delta[1], delta[1]}, physics.spring (k_s[1], k_d[1]), 0},
	    {{delta[2], delta[2]}, physics.spring (k_s[2], k_d[2]), 0},
	    {{delta[3], delta[3]}, physics.spring (k_s[3], k_d[3]), 0},
	 }
      end
   end

   meta.__tostring = function(self)
			 return "euler"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end
