-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "frames"

arrays = {}

function arrays.linear (values)
   local meta, self, oldindex, oldnewindex

   self = frames.array {
      spawn = function (self, i)
		 if (self[i]) then
		    self[i].position = {meta.length * (i - 1) / self.size, 0, 0}
		 end
	      end
   }

   meta = getmetatable (self)
   meta.length = 1
   meta.spacing = 1

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "length" then
			return meta.length
		     elseif key == "spacing" then
			return meta.spacing
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "length" then
	 meta.length = value
	 meta.spacing = value / self.size

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      elseif key == "spacing" then
	 meta.spacing = value
	 meta.length = value * self.size

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      elseif key == "size" then
	 oldnewindex(self, key, value)

	 for i = 1, self.size do
	    self.spawn (self, i)
	 end
      else
	 oldnewindex(self, key, value)
      end
   end

   meta.__tostring = function(self)
			 return "linear"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end

