/**
 * A layout manager for ncurses.
 */

#ifndef TCD_UI_LAYOUT_H
#define TCD_UI_LAYOUT_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#if defined(HAVE_NCURSES_H)
# include <ncurses.h>
#elif defined(HAVE_CURSES_H)
# include <curses.h>
#endif

/**
 * Coordinates of a box on the screen.
 */
struct coords {
    int top, left, bottom, right, height, width;
};

/**
 * Calculate all fields of a box from the arguments.
 */
extern void set_coords(struct coords *co, int top, int left, int bottom, int right);

/**
 * Draw a horizontal line with tee endpoints.
 */
extern void mvwhsplit(WINDOW *win, int y, int x, int len);
#define mvhsplit(m_y, m_x, m_len) \
        mvwhsplit(stdscr, m_y, m_x, m_len)

/**
 * Draw a vertical line with tee endpoints.
 */
extern void mvwvsplit(WINDOW *win, int y, int x, int len);
#define mvvsplit(m_y, m_x, m_len) \
        mvwvsplit(stdscr, m_y, m_x, m_len)

/**
 * Draw a (possibly long) string in a window. If the string is too long
 * to fit, the last three characters are replaced with "...".
 */
extern void mvwaddlstr(WINDOW *win, int y, int x, const char *s, int maxlen);
#define mvaddlstr(m_y, m_x, m_s, m_maxlen) \
        mvwaddlstr(stdscr, m_y, m_x, m_s, m_maxlen)

/**
 * Show a nice input box for the user.
 * Returns 0 on success, -1 on error.
 */
extern int input_box(char *buf, size_t bufsize, const char *title);

#endif
