/*  Synapse 0.1
 *  Copyright (C) 2006 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "synapse.h"

/**
	Funzione di convenienza per convertire un GtkTreePath riferito alla
	vista ad icone in un ID numerico per un file

	@param	path	La GtkTreePath da convertire
	@param	fileid	Puntatore che ospitera' il valore finale della
			conversione
*/
inline void fileid_by_path ( GtkTreePath *path, UINT64 *fileid ) {
	GtkTreeIter iter;

	if ( !gtk_tree_model_get_iter ( GTK_TREE_MODEL ( Graph.running->icons ), &iter, path ) ) {
		xfce_err ( _( "Unable to get file ID" ) );
		return;
	}

	gtk_tree_model_get ( GTK_TREE_MODEL ( Graph.running->icons ), &iter, ICON_VIEW_ID_COL, fileid, -1 );
}

/**
	Funzione di convenienza che, dato un ID numerico per un file, ne
	costruisce la path completa facendo riferimento alla path in cui e'
	stato trovato montato il filesystem Hyppocampus. Si sfrutta qui il
	fatto che Hyppocampus si riferisce ai singoli files sia con il loro
	nome che con il loro ID espresso in forma di stringa, e, facendo
	riferimento ad un file come "/mnt/hyppo/3" vengono restituite le
	informazioni relative al file con ID == 3

	@param	fileid	ID numerico di cui si vuol ricavare la path
	@param	filename	Stringa che verra' riempita con la path
				completa per il file
*/
inline void path_by_id ( UINT64 fileid, gchar *filename ) {
	( void ) snprintf ( filename, HYPPO_MAX_REAL_NAMELEN + 1 + DEFAULT_STRING_LENGHT, "%s/%0*llu",
	                    MountedPath, HYPPO_MAX_REAL_NAMELEN, fileid );
}

/**
	Inizializza l'array di traduzioni inverse che verra' usato nel
	sistema. Questo meccanismo funge in modo inverso rispetto alla
	traduzione canonica: all'interno dell'applicazione i nomi numerici
	dei metadati sono espressi come traduzioni effettuate con gettex, ma
	nel momento in cui si vuole ottenere nuovamente il nome numerico non
	esiste un metodo comodo per farlo. Dunque viene qui inizializzato un
	array che ospita le traduzioni leggibili dei nomi dei metadati e le
	confronta poi all'invocazione di reverse_translation() per ri-ottenere
	il formato UINT64
*/
void init_reverse_translations () {
	UINT64 i;

	for ( i = 0; i < METADATA_END; i++ )
		( void ) snprintf ( ReverseTranslations [ i ], MAX_LENGHT_FOR_METADATA_NAME, "%s",
					hyppo_metadata_translate_in_string ( AllMetadata [ i ].id ) );
}

/**
	Funzioncina di convenienza (che potrebbe anche essere espressa come
	macro...) per risalire in un colpo solo al puntatore del widget che
	ospita effettivamente la query scritta nella barra dell'applicazione.
	Il widget completo e' in realta' una GtkComboBoxEntry, in quanto oltre
	alla query ospita anche la history dell'applicazione, e sono
	necessari un po' di cast per arrivare al risultato che si desidera

	@return		Riferimento al GtkEntry che ospita la query immessa
			nell'apposita barra dell'applicazione
*/
inline GtkEntry* query_label_reference () {
	return GTK_ENTRY ( gtk_bin_get_child ( GTK_BIN ( GTK_COMBO_BOX_ENTRY ( Graph.query_text ) ) ) );
}

/**
	Effettua la traduzione inversa per ricavare dalla stringa leggibile
	che rappresenta un metadato il suo ID numerico

	@param	string	La stringa da tradurre inversamente

	@return		L'ID numerico del metadato espresso dalla stringa
			"string"
*/
inline UINT64 reverse_translation ( gchar *string ) {
	UINT64 i;

	for ( i = 0; i < METADATA_END; i++ )
		if ( !strcmp ( string, ReverseTranslations [ i ] ) )
			return i;

	return 0;
}

/**
	@param	item
	@param	text
	@param	shortcut
*/
void set_tooltip ( GtkWidget *item, gchar *text, ShortcutsTypes shortcut ) {
	gchar *complete_text	= NULL;
	gchar *sc		= NULL;

	if ( shortcut != S_MAX_SHORTCUTS ) {
		sc = kiazma_shortcuteditor_convert_num_to_string ( Confs.shortcuts [ shortcut ].modifier,
									Confs.shortcuts [ shortcut ].key );

		if ( sc )
			complete_text = g_strdup_printf ( "%s (%s)", text, sc );
	}

	if ( complete_text == NULL )
		complete_text = g_strdup ( text );

	gtk_tooltips_set_tip ( Graph.tooltips_group, item, complete_text, NULL );
	g_free ( complete_text );
}

/**
*/
inline void enable_tooltips () {
	if ( Confs.show_tooltips )
		gtk_tooltips_enable ( Graph.tooltips_group );
	else
		gtk_tooltips_disable ( Graph.tooltips_group );
}

/**
*/
gchar* get_system_path ( gchar *file ) {
	return g_strdup_printf ( "%s/%s/%s", g_get_home_dir (), DEFAULT_PATH_FOR_CONFIG_FILE, file );
}
