/*  Synapse 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "synapse.h"

#define DEFAULT_NAME_FOR_HISTORY_FILE		"history"

/**
	Used to retrive latest entry in the navigation history

	@return		The latest entry in the queries history. The value
			must be freed when no longer in use
*/
gchar* history_last () {
	gchar *last;
	GtkTreeModel *model;
	GtkTreeIter iter;

	model = gtk_combo_box_get_model ( GTK_COMBO_BOX ( Graph.query_text ) );
	if ( gtk_tree_model_get_iter_first ( model, &iter ) == FALSE )
		return NULL;

	gtk_tree_model_get ( model, &iter, 0, &last, -1 );
	return last;
}

/**
	Save a query in the history

	@param	query		Query to save in history
*/
void save_in_history ( gchar *query ) {
	gchar *path;
	gboolean exists			= FALSE;
	FILE *file;
	GtkTreeModel *model;
	GtkTreeIter iter;

	model = gtk_combo_box_get_model ( GTK_COMBO_BOX ( Graph.query_text ) );

	if ( gtk_tree_model_get_iter_first ( model, &iter ) == TRUE ) {
		do {
			gtk_tree_model_get ( GTK_TREE_MODEL ( model ), &iter, 0, &path, -1 );

			if ( !strcmp ( path, query ) ) {
				gtk_list_store_remove ( GTK_LIST_STORE ( model ), &iter );
				g_free ( path );
				exists = TRUE;
				break;
			}

			g_free ( path );
		} while ( gtk_tree_model_iter_next ( GTK_TREE_MODEL ( model ), &iter ) );
	}

	gtk_combo_box_prepend_text ( GTK_COMBO_BOX ( Graph.query_text ), g_strdup ( query ) );

	if ( exists == FALSE ) {
		path = get_system_path ( DEFAULT_NAME_FOR_HISTORY_FILE );
		file = fopen ( path, "a" );
		fprintf ( file, "%s\n", query );
		fclose ( file );
		g_free ( path );
	}
}

/**
	Load permanently saved history

	@todo		Use an XML file to store informations about actions
			instead the plain text here parsed
*/
void load_history () {
	gchar *string;
	gchar *path;
	GIOChannel *file;
	GError *error				= NULL;
	GIOStatus reading;

	path = get_system_path ( DEFAULT_NAME_FOR_HISTORY_FILE );
	file = g_io_channel_new_file ( path, "r", &error );

	if ( file == NULL ) {
		xfce_err ( _( "Unable to open the history file: %s" ), error->message );
		g_clear_error ( &error );
		fclose ( fopen ( path, "w" ) );
	}
	else {
		g_clear_error ( &error );
		reading = g_io_channel_read_line ( file, &string, NULL, NULL, &error );

		while ( reading != G_IO_STATUS_EOF && reading != G_IO_STATUS_ERROR ) {
			string [ strlen ( string ) - 1 ] = '\0';
			gtk_combo_box_prepend_text ( GTK_COMBO_BOX ( Graph.query_text ), string );
			reading = g_io_channel_read_line ( file, &string, NULL, NULL, &error );
		}

		g_io_channel_unref ( file );
	}

	g_free ( path );
}
