/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_WIDGET_H
#define KIAZMA_WIDGET_H

#include "libkiazma.h"

#define KIAZMA_WIDGET_TYPE			( kiazma_widget_get_type () )
#define KIAZMA_WIDGET(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_WIDGET_TYPE, KiazmaWidget ) )
#define KIAZMA_WIDGET_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_WIDGET_TYPE, KiazmaWidgetClass ) )
#define IS_KIAZMA_WIDGET(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_WIDGET_TYPE ) )
#define IS_KIAZMA_WIDGET_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_WIDGET_TYPE ) )

typedef struct _KiazmaWidget			KiazmaWidget;
typedef struct _KiazmaWidgetClass		KiazmaWidgetClass;

struct _KiazmaWidget {
	GtkWidget		main;
	UINT64			file;
};

struct _KiazmaWidgetClass {
	GtkWidgetClass			parent_class;
	void ( *kiazma_widget )		( KiazmaWidget *item );
};

GType		kiazma_widget_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_widget_new		( UINT64 file );

#endif /* KIAZMA_WIDGET_H */
