/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_TIME_H
#define KIAZMA_TIME_H

#include "libkiazma.h"

#define KIAZMA_TIME_TYPE			( kiazma_time_get_type () )
#define KIAZMA_TIME(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_TIME_TYPE, KiazmaTime ) )
#define KIAZMA_TIME_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_TIME_TYPE, KiazmaTimeClass ) )
#define IS_KIAZMA_TIME(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_TIME_TYPE ) )
#define IS_KIAZMA_TIME_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_TIME_TYPE ) )

typedef struct _KiazmaTime			KiazmaTime;
typedef struct _KiazmaTimeClass			KiazmaTimeClass;

struct _KiazmaTime {
	GtkExpander		button;
	GtkWidget		*calendar;
	GtkWidget		*hour;
	time_t			date;
};

struct _KiazmaTimeClass {
	GtkExpanderClass	parent_class;
	void ( *kiazma_time ) ( KiazmaTime *synp );
};

GType		kiazma_time_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_time_new			();
void		kiazma_time_clear		( KiazmaTime *synp );
time_t		kiazma_time_get_value		( KiazmaTime *synp );
void		kiazma_time_set_value		( KiazmaTime *synp, time_t value );

#endif /* KIAZMA_TIME_H */
