/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_FRAME_H
#define KIAZMA_FRAME_H

#include "libkiazma.h"

#define KIAZMA_FRAME_TYPE			( kiazma_frame_get_type () )
#define KIAZMA_FRAME(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_FRAME_TYPE, KiazmaFrame ) )
#define KIAZMA_FRAME_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_FRAME_TYPE, KiazmaFrameClass ) )
#define IS_KIAZMA_FRAME(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_FRAME_TYPE ) )
#define IS_KIAZMA_FRAME_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_FRAME_TYPE ) )

typedef struct _KiazmaFrame			KiazmaFrame;
typedef struct _KiazmaFrameClass		KiazmaFrameClass;

struct _KiazmaFrame {
	GtkFrame		frame;
	GtkWidget		*box;
	GtkSizeGroup		*sg;
};

struct _KiazmaFrameClass {
	GtkFrameClass		parent_class;
	void ( *kiazma_frame ) ( KiazmaFrame *synp );
};

GType		kiazma_frame_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_frame_new			( gchar *title );
GtkWidget*	kiazma_frame_new_empty			( gchar *title );
GtkWidget*	kiazma_frame_new_from_group		( gchar *title, GtkSizeGroup *group );
void		kiazma_frame_add			( KiazmaFrame *frame, gchar *title, GtkWidget *item );
void		kiazma_frame_free_add			( KiazmaFrame *frame, GtkWidget *item );
GtkSizeGroup*	kiazma_frame_get_group			( KiazmaFrame *frame );

#endif /* KIAZMA_FRAME_H */
