/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_enumeration_combo.c
*/

#include "libkiazma.h"
#include "kiazma_enumeration_combo.h"

static void kiazma_enumeration_combo_class_init ( KiazmaEnumerationComboClass *klass ) {
	return;
}

static void kiazma_enumeration_combo_init ( KiazmaEnumerationCombo *ttt ) {
	GtkCellRenderer *cell;

	cell = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start ( GTK_CELL_LAYOUT ( ttt ), cell, TRUE );
	gtk_cell_layout_set_attributes ( GTK_CELL_LAYOUT ( ttt ), cell, "text", 0, NULL );
}

GType kiazma_enumeration_combo_get_type () {
	static GType ttt_type		= 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaEnumerationComboClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_enumeration_combo_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaEnumerationCombo ),
			0,
			( GInstanceInitFunc ) kiazma_enumeration_combo_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_COMBO_BOX, "KiazmaEnumerationCombo", &ttt_info, 0 );
	}

	return ttt_type;
}

static void extract_values_enum ( GtkWidget *combo, HYPPO_ENUMERATIONS enumeration ) {
	register int i;
	const char *string;
	GtkTreeIter child;
	GtkTreeStore *model;

	model = gtk_tree_store_new ( 1, G_TYPE_STRING );

	i = 0;
	string = hyppo_translate_enum_to_string ( i++, enumeration );

	while ( string ) {
		gtk_tree_store_append ( model, &child, NULL );
		gtk_tree_store_set ( model, &child, 0, string, -1 );
		string = hyppo_translate_enum_to_string ( ++i, enumeration );
	}

	gtk_combo_box_set_model ( GTK_COMBO_BOX ( combo ), ( GtkTreeModel* ) model );
}

GtkWidget* kiazma_enumeration_combo_new ( HYPPO_ENUMERATIONS enumeration ) {
	GtkWidget *new_item;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_enumeration_combo_get_type (), NULL ) );
	extract_values_enum ( new_item, enumeration );
	return new_item;
}
