/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
	Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
*/

/**
	@file	kiazma_drawing_area.c
*/

#include "libkiazma.h"
#include "kiazma_drawing_area.h"

static void kiazma_drawing_area_class_init ( KiazmaDrawingAreaClass *klass ) {
	return;
}

/**
	@internal

	@param	widget
	@param	event

	@return
*/
static gboolean handle_configure ( GtkWidget *widget, GdkEventConfigure *event ) {
	KiazmaDrawingArea *area;

	area = KIAZMA_DRAWING_AREA ( widget );

	if ( area->pixmap )
		g_object_unref ( area->pixmap );

	area->pixmap = gdk_pixmap_new ( widget->window, widget->allocation.width, widget->allocation.height, -1 );
	gdk_draw_rectangle ( area->pixmap, widget->style->base_gc [ GTK_WIDGET_STATE ( widget ) ], TRUE, 0, 0,
				widget->allocation.width, widget->allocation.height );

	return FALSE;
}

/**
	@internal

	@param	widget
	@param	event

	@return
*/
static gboolean handle_expose ( GtkWidget *widget, GdkEventExpose *event ) {
	KiazmaDrawingArea *area;

	area = KIAZMA_DRAWING_AREA ( widget );
	gdk_draw_drawable ( widget->window, widget->style->fg_gc [ GTK_WIDGET_STATE ( widget ) ], area->pixmap,
				event->area.x, event->area.y, event->area.x, event->area.y,
				event->area.width, event->area.height );

	return FALSE;
}

/**
	@internal

	@param	widget
	@param	x
	@param	y
*/
static void draw_brush ( GtkWidget *widget, gdouble x, gdouble y ) {
	KiazmaDrawingArea *area;
	GdkRectangle update_rect;

	update_rect.x = x;
	update_rect.y = y;
	update_rect.width = 2;
	update_rect.height = 2;

	area = KIAZMA_DRAWING_AREA ( widget );
	gdk_draw_rectangle ( area->pixmap, widget->style->black_gc, TRUE,
				update_rect.x, update_rect.y, update_rect.width, update_rect.height );
	gtk_widget_queue_draw_area ( widget, update_rect.x, update_rect.y, update_rect.width, update_rect.height );
}

/**
	@internal

	@param	widget
	@param	event

	@return
*/
static gboolean handle_motion_notify ( GtkWidget *widget, GdkEventMotion *event ) {
	int x;
	int y;
	GdkModifierType state;

	if ( event->is_hint )
		gdk_window_get_pointer ( event->window, &x, &y, &state );

	else {
		x = event->x;
		y = event->y;
		state = event->state;
	}

	if ( state & GDK_BUTTON1_MASK && KIAZMA_DRAWING_AREA ( widget )->pixmap != NULL )
		draw_brush ( widget, x, y );

	return FALSE;
}

/**
	@internal

	@param	widget
	@param	event

	@return
*/
static gboolean handle_button_press_while_drawing ( GtkWidget *widget, GdkEventButton *event ) {
	if ( event->button == 1 && KIAZMA_DRAWING_AREA ( widget )->pixmap != NULL )
		draw_brush ( widget, event->x, event->y );

	return FALSE;
}

static void kiazma_drawing_area_init ( KiazmaDrawingArea *ttt ) {
	gtk_widget_set_events ( GTK_WIDGET ( ttt ), GDK_EXPOSURE_MASK | GDK_LEAVE_NOTIFY_MASK |
				GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK );

	g_signal_connect ( G_OBJECT ( ttt ), "configure_event", G_CALLBACK ( handle_configure ), NULL );
	g_signal_connect ( G_OBJECT ( ttt ), "expose_event", G_CALLBACK ( handle_expose ), NULL );
	g_signal_connect ( G_OBJECT ( ttt ), "motion_notify_event", G_CALLBACK ( handle_motion_notify ), NULL );
	g_signal_connect ( G_OBJECT ( ttt ), "button_press_event", G_CALLBACK ( handle_button_press_while_drawing ), NULL );
}

GType kiazma_drawing_area_get_type () {
	static GType ttt_type		= 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaDrawingAreaClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_drawing_area_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaDrawingArea ),
			0,
			( GInstanceInitFunc ) kiazma_drawing_area_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_DRAWING_AREA, "KiazmaDrawingArea", &ttt_info, 0 );
	}

	return ttt_type;
}

GtkWidget* kiazma_drawing_area_new () {
	return GTK_WIDGET ( g_object_new ( kiazma_drawing_area_get_type (), NULL ) );
}

GdkPixmap* kiazma_drawing_area_get_draw ( KiazmaDrawingArea *area ) {
	return area->pixmap;
}
