/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_BUTTON_STOCK_H
#define KIAZMA_BUTTON_STOCK_H

#include "libkiazma.h"

#define KIAZMA_BUTTON_STOCK_TYPE			( kiazma_button_stock_get_type () )
#define KIAZMA_BUTTON_STOCK(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_BUTTON_STOCK_TYPE, KiazmaButtonStock ) )
#define KIAZMA_BUTTON_STOCK_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_BUTTON_STOCK_TYPE, KiazmaButtonStockClass ) )
#define IS_KIAZMA_BUTTON_STOCK(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_BUTTON_STOCK_TYPE ) )
#define IS_KIAZMA_BUTTON_STOCK_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_BUTTON_STOCK_TYPE ) )

typedef struct _KiazmaButtonStock			KiazmaButtonStock;
typedef struct _KiazmaButtonStockClass			KiazmaButtonStockClass;

struct _KiazmaButtonStock {
	GtkButton			main_win;
};

struct _KiazmaButtonStockClass {
	GtkButtonClass				parent_class;
	void ( *kiazma_button_stock )		( KiazmaButtonStock *synp );
};

GType		kiazma_button_stock_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_button_stock_new				( const gchar *stock );

#endif /* KIAZMA_BUTTON_STOCK_H */
