#!/bin/sh

#gpg (GnuPG) 1.0.7
#gpg (GnuPG) 1.2.1

GPG=`which gpg`
version="`$GPG --version 2>/dev/null | grep Gnu | head -1 | awk '{print $NF}'`"

case "$version" in 
	1.0.[0-6])
		echo "GnuPG 1.0.[0-6] cannot be used for this test." 1>&2
		echo "You need revision 1.0.7 or 1.2.1" 1>&2
		exit 1
		;;	
	1.2.[0-9])
		# OK
		echo 1>/dev/null
		;;
	1.0.7)
		# OK
		echo 1>/dev/null
		;;
	*)
		echo "GNU Privacy Guard revision 1.0.7 or 1.2.x is required." 1>&2
		echo "You have tar [$version]." 1>&2
		echo "This test has not been run." 1>&2
		exit 1
		;;
esac

exit 0
