/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.mapping.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.lang.Macro;

public class ModuleExp
extends LambdaExp {
    public boolean mustCompile;
    public static final int EXPORT_SPECIFIED = 1024;
    public static final int STATIC_SPECIFIED = 2048;
    public static final int NONSTATIC_SPECIFIED = 4096;
    public static final int SUPERTYPE_SPECIFIED = 8192;
    ClassType superType;
    ClassType[] interfaces;

    void allocFields(Compilation compilation) {
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (!(declaration.isSimple() && !declaration.isPublic() || declaration instanceof Macro && ((Macro)declaration).expander instanceof LambdaExp && !declaration.isPrivate())) {
                Expression expression = declaration.getValue();
                if (expression instanceof LambdaExp) {
                    ((LambdaExp)expression).allocFieldFor(compilation);
                } else {
                    if (!(expression instanceof QuoteExp) || !declaration.getFlag(16384) || compilation.immediate) {
                        expression = null;
                    }
                    declaration.makeField(compilation, expression);
                }
            }
            declaration = declaration.nextDecl();
        }
    }

    public void compileToArchive(String string) throws IOException {
        boolean bl = false;
        if (string.endsWith(".zip")) {
            bl = false;
        } else if (string.endsWith(".jar")) {
            bl = true;
        } else {
            string = String.valueOf(string) + ".zip";
            bl = false;
        }
        Compilation compilation = new Compilation(this, LambdaExp.fileFunctionName, null, false);
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setMethod(0);
        byte[][] byArray = new byte[compilation.numClasses][];
        CRC32 cRC32 = new CRC32();
        int n = 0;
        while (n < compilation.numClasses) {
            ClassType classType = compilation.classes[n];
            byArray[n] = classType.writeToArray();
            ZipEntry zipEntry = new ZipEntry(String.valueOf(classType.getName().replace('.', '/')) + ".class");
            zipEntry.setSize(byArray[n].length);
            cRC32.reset();
            cRC32.update(byArray[n], 0, byArray[n].length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray[n]);
            ++n;
        }
        zipOutputStream.close();
    }

    public void compileToFiles(String string, String string2, String string3) throws IOException {
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + '/';
        }
        String string4 = this.getName();
        if (string4 != null) {
            int n;
            string = string4;
            if (string3 == null && (n = string4.lastIndexOf(46)) >= 0) {
                string3 = string4.substring(0, n + 1);
            }
        }
        Compilation compilation = new Compilation(this, string, string3, false);
        int n = 0;
        while (n < compilation.numClasses) {
            ClassType classType = compilation.classes[n];
            String string5 = String.valueOf(string2) + classType.getName().replace('.', File.separatorChar) + ".class";
            String string6 = new File(string5).getParent();
            if (string6 != null) {
                new File(string6).mkdirs();
            }
            classType.writeToFile(string5);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evalModule(Environment environment) {
        Object object2;
        Environment environment2;
        block5: {
            Object object3;
            block4: {
                environment2 = Environment.getCurrent();
                try {
                    if (environment != environment2) {
                        Environment.setCurrent(environment);
                    }
                    if (!this.mustCompile) {
                        object3 = this.body.eval(environment);
                        Object var5_5 = null;
                        if (environment == environment2) return object3;
                        break block4;
                    }
                    ModuleBody moduleBody = (ModuleBody)this.eval(environment);
                    ClassMemberConstraint.defineAll(moduleBody, environment);
                    object2 = moduleBody.run();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (environment == environment2) throw throwable;
                    Environment.setCurrent(environment2);
                    throw throwable;
                }
            }
            Environment.setCurrent(environment2);
            return object3;
        }
        Object var5_6 = null;
        if (environment == environment2) return object2;
        Environment.setCurrent(environment2);
        return object2;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final boolean isStatic() {
        return this.getFlag(2048) || Compilation.moduleStatic > 0 && !this.getFlag(8192) && !this.getFlag(4096);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%module/");
        if (this.name != null) {
            printWriter.print(this.name);
            printWriter.print('/');
        }
        printWriter.print(this.id);
        printWriter.println("/ (");
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            printWriter.print("  ");
            printWriter.println(declaration);
            declaration = declaration.nextDecl();
        }
        printWriter.print(") ");
        if (this.body == null) {
            printWriter.print("<null body>");
        } else {
            this.body.print(printWriter);
        }
        printWriter.print(")");
    }

    public final void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public final void setSuperType(ClassType classType) {
        this.superType = classType;
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkModuleExp(this);
    }
}

