/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class S32Vector
extends UniformVector
implements Externalizable {
    int[] data;

    public S32Vector() {
    }

    public S32Vector(int n) {
        this.data = new int[n];
    }

    public S32Vector(int n, int n2) {
        int[] nArray = new int[n];
        this.data = nArray;
        while (--n >= 0) {
            nArray[n] = n2;
        }
    }

    public S32Vector(Sequence sequence) {
        this.data = new int[sequence.length()];
        this.copy(sequence);
    }

    public S32Vector(int[] nArray) {
        this.data = nArray;
    }

    public final Object get(int n) {
        return IntNum.make(this.data[n]);
    }

    public final String getTag() {
        return "s32";
    }

    public final int intValue(int n) {
        return this.data[n];
    }

    public final int length() {
        return this.data.length;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.intValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = objectInput.readInt();
            ++n2;
        }
        this.data = nArray;
    }

    public final void set(int n, int n2) {
        this.data[n] = n2;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).intValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeInt(this.data[n2]);
            ++n2;
        }
    }
}

