/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;

public class BufferLocalConstraint
extends Constraint {
    Constraint oldConstraint;
    boolean all;
    Buffer lastBuffer;
    Object lastValue;
    Object[] bufferBindings;

    public Object get(Binding binding) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return this.lastValue;
            }
        } else if (this.bufferBindings != null) {
            int n = this.bufferBindings.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.bufferBindings[n2] == buffer) {
                    this.save();
                    this.lastBuffer = buffer;
                    this.lastValue = this.bufferBindings[n2 + 1];
                    if (this.lastValue == this) break;
                    return this.lastValue;
                }
                n2 += 2;
            }
        }
        this.lastValue = this.oldConstraint.get(binding);
        this.lastBuffer = buffer;
        return this.lastValue;
    }

    public Environment getEnvironment(Binding binding) {
        return this.oldConstraint.getEnvironment(binding);
    }

    public boolean isBound(Binding binding) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return true;
            }
        } else if (this.bufferBindings != null) {
            this.save();
            this.lastBuffer = buffer;
            int n = this.bufferBindings.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.bufferBindings[n2] == buffer) {
                    this.lastValue = this.bufferBindings[n2 + 1];
                    if (this.lastValue == this) break;
                    return true;
                }
                n2 += 2;
            }
            this.lastValue = this;
        }
        return this.oldConstraint.isBound(binding);
    }

    public static void make(Binding binding, boolean bl) {
        BufferLocalConstraint bufferLocalConstraint;
        Constraint constraint = Constraint.getConstraint(binding);
        if (constraint instanceof BufferLocalConstraint) {
            bufferLocalConstraint = (BufferLocalConstraint)constraint;
        } else {
            bufferLocalConstraint = new BufferLocalConstraint();
            bufferLocalConstraint.all = bl;
            bufferLocalConstraint.oldConstraint = constraint;
            binding.setConstraint(bufferLocalConstraint);
        }
        if (!bl) {
            Buffer buffer = Buffer.getCurrent();
            if (bufferLocalConstraint.lastBuffer != buffer) {
                bufferLocalConstraint.save();
            }
            bufferLocalConstraint.lastBuffer = buffer;
            bufferLocalConstraint.lastValue = bufferLocalConstraint;
        }
    }

    private void save() {
        if (this.lastBuffer == null || this.lastValue == this) {
            return;
        }
        if (this.bufferBindings == null) {
            this.bufferBindings = new Object[20];
            this.bufferBindings[0] = this.lastBuffer;
            this.bufferBindings[1] = this.lastValue;
            return;
        }
        int n = this.bufferBindings.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.bufferBindings[n2] == this.lastBuffer) {
                this.bufferBindings[n2 + 1] = this.lastValue;
                return;
            }
            n2 += 2;
        }
        Object[] objectArray = new Object[2 * n];
        System.arraycopy(this.bufferBindings, 0, objectArray, 0, n);
        objectArray[n] = this.lastBuffer;
        objectArray[n + 1] = this.lastValue;
        this.bufferBindings = objectArray;
    }

    public void set(Binding binding, Object object2) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer != this.lastBuffer) {
            this.save();
            this.lastBuffer = buffer;
            int n = this.bufferBindings.length;
            int n2 = 0;
            while (true) {
                if (n2 == n) {
                    this.lastValue = this;
                    break;
                }
                if (this.bufferBindings[n2] == buffer) {
                    this.lastValue = this.bufferBindings[n2 + 1];
                    break;
                }
                n2 += 2;
            }
        }
        if (this.all || this.lastValue != this) {
            this.lastValue = object2;
            return;
        }
        this.oldConstraint.set(binding, object2);
    }
}

