/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleMethod;
import gnu.expr.Target;
import gnu.kawa.util.LList;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import kawa.standard.list_v;

public class PrimProcedure
extends MethodProc
implements Inlineable {
    Type retType;
    Type[] argTypes;
    Method method;
    int op_code;
    LambdaExp source;
    Member member;
    private static ClassLoader systemClassLoader = (class$gnu$expr$PrimProcedure != null ? class$gnu$expr$PrimProcedure : (class$gnu$expr$PrimProcedure = PrimProcedure.class$("gnu.expr.PrimProcedure"))).getClassLoader();
    static /* synthetic */ Class class$gnu$expr$PrimProcedure;

    public PrimProcedure(int n, ClassType classType, String string, Type type, Type[] typeArray) {
        this.op_code = n;
        if (n == 185) {
            classType.access_flags |= 0x200;
        }
        this.method = classType.addMethod(string, n == 184 ? 8 : 0, typeArray, type);
        this.retType = type;
        this.argTypes = typeArray;
    }

    public PrimProcedure(int n, Type type, Type[] typeArray) {
        this.op_code = n;
        this.retType = type;
        this.argTypes = typeArray;
    }

    public PrimProcedure(ClassType classType, Type[] typeArray) {
        this(183, classType, "<init>", Type.void_type, typeArray);
        this.retType = classType;
    }

    public PrimProcedure(Method method) {
        this.init(method);
    }

    public PrimProcedure(Method method, Interpreter interpreter) {
        this.init(method);
        Type[] typeArray = method.getParameterTypes();
        int n = typeArray.length;
        this.argTypes = null;
        int n2 = n;
        while (--n2 >= 0) {
            Type type = typeArray[n2];
            Type type2 = interpreter.getTypeFor(type.getReflectClass());
            if (type == type2) continue;
            if (this.argTypes == null) {
                this.argTypes = new Type[n];
                System.arraycopy(typeArray, 0, this.argTypes, 0, n);
            }
            this.argTypes[n2] = type2;
        }
        if (this.argTypes == null) {
            this.argTypes = typeArray;
        }
        this.retType = this.op_code == 183 ? method.getDeclaringClass() : interpreter.getTypeFor(method.getReturnType().getReflectClass());
    }

    public PrimProcedure(Method method, LambdaExp lambdaExp) {
        this(method);
        this.source = lambdaExp;
    }

    public PrimProcedure(java.lang.reflect.Method method, Interpreter interpreter) {
        this(method, method.getDeclaringClass(), method.getParameterTypes(), interpreter);
    }

    public PrimProcedure(java.lang.reflect.Method method, Class clazz, Class[] classArray, Interpreter interpreter) {
        Type[] typeArray = new Type[classArray.length];
        int n = classArray.length;
        while (--n >= 0) {
            typeArray[n] = interpreter.getTypeFor(classArray[n]);
        }
        Type type = interpreter.getTypeFor(method.getReturnType());
        ClassType classType = (ClassType)interpreter.getTypeFor(clazz);
        this.init(classType.addMethod(method.getName(), method.getModifiers(), typeArray, type));
    }

    public Object applyV(Object object2) {
        Object[] objectArray = (Object[])object2;
        int n = this.argTypes.length;
        boolean bl = this.op_code == 183;
        boolean bl2 = this.getStaticFlag();
        try {
            Object object3;
            GenericDeclaration genericDeclaration;
            if (this.member == null) {
                genericDeclaration = this.method.getDeclaringClass().getReflectClass();
                object3 = new Class[n];
                int n2 = n;
                while (--n2 >= 0) {
                    object3[n2] = this.argTypes[n2].getReflectClass();
                }
                this.member = bl ? ((Class)genericDeclaration).getConstructor((Class<?>)object3) : ((Class)genericDeclaration).getMethod(this.method.getName(), (Class<?>)object3);
            }
            if (bl) {
                return ((Constructor)this.member).newInstance(objectArray);
            }
            genericDeclaration = (java.lang.reflect.Method)this.member;
            if (this.method.getStaticFlag()) {
                object3 = ((java.lang.reflect.Method)genericDeclaration).invoke(null, objectArray);
            } else {
                Object[] objectArray2 = new Object[n];
                System.arraycopy(objectArray, 1, objectArray2, 0, n);
                object3 = ((java.lang.reflect.Method)genericDeclaration).invoke(objectArray[0], objectArray2);
            }
            return this.retType.coerceToObject(object3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable.toString());
        }
        catch (Exception exception) {
            throw new RuntimeException("apply not implemented for PrimProcedure " + this + " - " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void compile(Type type, Expression[] expressionArray, Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        PrimProcedure.compileArgs(expressionArray, type, this.argTypes, this.takesVarArgs(), this.getName(), this.source, compilation);
        if (this.method == null) {
            codeAttr.emitPrimop(this.opcode(), expressionArray.length, this.retType);
        } else {
            codeAttr.emitInvokeMethod(this.method, this.opcode());
        }
        target.compileFromStack(compilation, this.retType);
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        String string;
        Expression[] expressionArray;
        CodeAttr codeAttr = compilation.getCode();
        if (this.opcode() == 183) {
            expressionArray = this.method.getDeclaringClass();
            codeAttr.emitNew((ClassType)expressionArray);
            codeAttr.emitDup((Type)expressionArray);
        }
        if ((string = WrongArguments.checkArgCount(this, (expressionArray = applyExp.getArgs()).length)) != null) {
            compilation.error('e', string);
        }
        this.compile(this.getStaticFlag() ? null : this.method.getDeclaringClass(), expressionArray, compilation, target);
    }

    public static void compileArgs(Expression[] expressionArray, Type type, Type[] typeArray, boolean bl, String string, LambdaExp lambdaExp, Compilation compilation) {
        boolean bl2;
        Type type2 = null;
        CodeAttr codeAttr = compilation.getCode();
        int n = type == Type.void_type ? 1 : 0;
        int n2 = typeArray.length - n;
        boolean bl3 = bl2 = type == null || n != 0;
        int n3 = bl ? n2 - (bl2 ? 1 : 2) : expressionArray.length;
        int n4 = 0;
        while (true) {
            if (bl && n4 == n3) {
                type2 = typeArray[n2 - 1 + n];
                if (type2 == Compilation.scmListType) {
                    list_v.compile(expressionArray, n4, compilation);
                    break;
                }
                codeAttr.emitPushInt(expressionArray.length - n3);
                type2 = ((ArrayType)type2).getComponentType();
                codeAttr.emitNewArray(type2);
            }
            if (n4 >= expressionArray.length) break;
            if (n4 >= n3) {
                codeAttr.emitDup(1);
                codeAttr.emitPushInt(n4 - n3);
            } else {
                type2 = bl2 ? typeArray[n4 + n] : (n4 == 0 ? type : typeArray[n4 - 1]);
            }
            expressionArray[n4].compile(compilation, lambdaExp == null ? CheckedTarget.getInstance(type2, string, n4) : CheckedTarget.getInstance(type2, lambdaExp, n4));
            if (n4 >= n3) {
                codeAttr.emitArrayStore(type2);
            }
            ++n4;
        }
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Declaration declaration, Expression[] expressionArray, Interpreter interpreter) {
        Class<?> clazz = procedure instanceof ModuleMethod ? ((ModuleMethod)procedure).module.getClass() : procedure.getClass();
        if (clazz.getClassLoader() != systemClassLoader) {
            return null;
        }
        try {
            Object object2;
            java.lang.reflect.Method[] methodArray = clazz.getDeclaredMethods();
            Object object3 = null;
            Class<?>[] classArray = null;
            String string = procedure.getName();
            if (string == null) {
                return null;
            }
            String string2 = declaration == null || declaration.field == null ? Compilation.mangleName(string) : declaration.field.getName();
            String string3 = String.valueOf(string2) + "$V";
            int n = methodArray.length;
            while (--n >= 0) {
                boolean bl;
                boolean bl2;
                object2 = methodArray[n];
                int n2 = ((java.lang.reflect.Method)object2).getModifiers();
                if ((n2 & 9) != 9 && (declaration == null || declaration.base == null)) continue;
                String string4 = ((java.lang.reflect.Method)object2).getName();
                if (string4.equals("apply") || string4.equals(string2)) {
                    bl2 = false;
                } else {
                    if (!string4.equals("apply$V") && !string4.equals(string3)) continue;
                    bl2 = true;
                }
                Class<?>[] classArray2 = ((java.lang.reflect.Method)object2).getParameterTypes();
                if (bl2) {
                    if (classArray2.length - 1 > expressionArray.length) continue;
                    bl = false;
                } else {
                    if (classArray2.length != expressionArray.length) continue;
                    bl = false;
                }
                if (bl) continue;
                if (object3 != null) {
                    return null;
                }
                object3 = object2;
                classArray = classArray2;
            }
            if (object3 != null) {
                object2 = new PrimProcedure((java.lang.reflect.Method)object3, clazz, classArray, interpreter);
                ((Procedure)object2).setName(string);
                return object2;
            }
        }
        catch (SecurityException securityException) {}
        return null;
    }

    public static PrimProcedure getMethodFor(Procedure procedure, Expression[] expressionArray) {
        return PrimProcedure.getMethodFor(procedure, null, expressionArray, Interpreter.getInterpreter());
    }

    public String getName() {
        String string = super.getName();
        if (string != null) {
            return string;
        }
        string = this.getVerboseName();
        this.setName(string);
        return string;
    }

    public Type getParameterType(int n) {
        int n2;
        if (!this.getStaticFlag()) {
            if (n == 0) {
                return this.method.getDeclaringClass();
            }
            --n;
        }
        if (n < (n2 = this.argTypes.length) - 1) {
            return this.argTypes[n];
        }
        boolean bl = this.takesVarArgs();
        if (n < n2 && !bl) {
            return this.argTypes[n];
        }
        return ((ArrayType)this.argTypes[n2 - 1]).getComponentType();
    }

    public final Type[] getParameterTypes() {
        return this.argTypes;
    }

    public Type getReturnType() {
        return this.retType;
    }

    public Type getReturnType(Expression[] expressionArray) {
        return this.retType;
    }

    public final boolean getStaticFlag() {
        return this.method == null || this.method.getStaticFlag() || this.op_code == 183;
    }

    public Object getVarBuffer() {
        return new Object[this.minArgs() + (this.takesVarArgs() ? 1 : 0)];
    }

    public String getVerboseName() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.method == null) {
            stringBuffer.append("<op ");
            stringBuffer.append(this.op_code);
            stringBuffer.append('>');
        } else {
            stringBuffer.append(this.method.getDeclaringClass().getName());
            stringBuffer.append('.');
            stringBuffer.append(this.method.getName());
        }
        stringBuffer.append('(');
        int n = 0;
        while (n < this.argTypes.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.argTypes[n].getName());
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private void init(Method method) {
        ClassType classType;
        this.method = method;
        this.argTypes = method.getParameterTypes();
        this.retType = method.getReturnType();
        int n = method.getModifiers();
        this.op_code = (n & 8) != 0 ? 184 : (((classType = method.getDeclaringClass()).getModifiers() & 0x200) != 0 ? 185 : ("<init>".equals(method.getName()) ? 183 : 182));
    }

    public RuntimeException match(Object object2, Object[] objectArray) {
        int n;
        Object object3;
        int n2;
        boolean bl;
        int n3;
        block16: {
            block14: {
                boolean bl2;
                block15: {
                    Object[] objectArray2;
                    block13: {
                        n3 = objectArray.length;
                        objectArray2 = (Object[])object2;
                        bl = this.takesVarArgs();
                        int n4 = n2 = bl ? objectArray2.length - 1 : objectArray2.length;
                        if (!bl) break block13;
                        if (n3 < n2) break block14;
                        bl2 = false;
                        break block15;
                    }
                    if (n3 != objectArray2.length) break block14;
                    bl2 = false;
                }
                if (!bl2) break block16;
            }
            return new WrongArguments(this, n3);
        }
        int n5 = this.argTypes.length;
        Type type = null;
        Object[] objectArray3 = null;
        if (bl) {
            Type type2 = this.argTypes[n5 - 1];
            if (type2 == Compilation.scmListType) {
                objectArray2[objectArray2.length - 1] = LList.makeList(objectArray, n2);
                n3 = n2;
            } else {
                ArrayType arrayType = (ArrayType)type2;
                type = arrayType.getComponentType();
                object3 = type.getReflectClass();
                objectArray2[objectArray2.length - 1] = objectArray3 = (Object[])Array.newInstance(object3, n3 - n2);
            }
        }
        int n6 = n = this.getStaticFlag() ? 0 : 1;
        if (n != 0) {
            objectArray2[0] = this.method.getDeclaringClass().coerceFromObject(objectArray[0]);
        }
        int n7 = n;
        while (n7 < n3) {
            try {
                Type type3;
                object3 = objectArray[n7];
                Type type4 = type3 = n7 < n2 ? this.argTypes[n7 - n] : type;
                if (type3 != Type.pointer_type) {
                    object3 = type3.coerceFromObject(object3);
                }
                if (n7 < n2) {
                    objectArray2[n7] = object3;
                } else {
                    objectArray3[n7 - n2] = object3;
                }
            }
            catch (ClassCastException classCastException) {
                return new WrongType(this, n7, classCastException);
            }
            ++n7;
        }
        return null;
    }

    public int numArgs() {
        int n = this.argTypes.length;
        if (!this.getStaticFlag()) {
            ++n;
        }
        return this.takesVarArgs() ? n - 1 + -4096 : n + (n << 12);
    }

    public final int opcode() {
        return this.op_code;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<primitive procedure ");
        printWriter.print(this.toString());
        printWriter.print('>');
    }

    public void setReturnType(Type type) {
        this.retType = type;
    }

    public boolean takesVarArgs() {
        return this.method.getName().endsWith("$V");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.retType.getName());
        stringBuffer.append(' ');
        stringBuffer.append(this.getVerboseName());
        return stringBuffer.toString();
    }
}

