/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;

public class PrimType
extends Type {
    protected PrimType(PrimType type) {
        super(type.this_name, type.signature);
        this.size = type.size;
        this.reflectClass = type.reflectClass;
    }

    public PrimType(String nam, String sig, int siz, Class reflectClass) {
        super(nam, sig);
        this.size = siz;
        this.reflectClass = reflectClass;
        Type.registerTypeForClass(reflectClass, this);
    }

    public boolean booleanValue(Object value) {
        return !(value instanceof Boolean) || (Boolean)value != false;
    }

    public char charValue(Object value) {
        return ((Character)value).charValue();
    }

    public Object coerceFromObject(Object obj) {
        if (obj.getClass() == this.reflectClass) {
            return obj;
        }
        int sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        switch (sig1) {
            case 66: {
                return new Byte(((Number)obj).byteValue());
            }
            case 83: {
                return new Short(((Number)obj).shortValue());
            }
            case 73: {
                return new Integer(((Number)obj).intValue());
            }
            case 74: {
                return new Long(((Number)obj).longValue());
            }
            case 70: {
                return new Float(((Number)obj).floatValue());
            }
            case 68: {
                return new Double(((Number)obj).doubleValue());
            }
        }
        throw new ClassCastException("don't know how to coerce " + obj.getClass().getName() + " to " + this.getName());
    }

    public static int compare(PrimType type1, PrimType type2) {
        char sig2;
        char sig1 = type1.signature.charAt(0);
        if (sig1 == (sig2 = type2.signature.charAt(0))) {
            return 0;
        }
        if (sig1 == 'V') {
            return 1;
        }
        if (sig2 == 'V') {
            return -1;
        }
        if (sig1 == 'Z' || sig2 == 'Z') {
            return -3;
        }
        if (sig1 == 'C') {
            return type2.size > 2 ? -1 : -3;
        }
        if (sig2 == 'C') {
            return type1.size > 2 ? 1 : -3;
        }
        if (sig1 == 'D') {
            return 1;
        }
        if (sig2 == 'D') {
            return -1;
        }
        if (sig1 == 'F') {
            return 1;
        }
        if (sig2 == 'F') {
            return -1;
        }
        if (sig1 == 'J') {
            return 1;
        }
        if (sig2 == 'J') {
            return -1;
        }
        if (sig1 == 'I') {
            return 1;
        }
        if (sig2 == 'I') {
            return -1;
        }
        if (sig1 == 'S') {
            return 1;
        }
        if (sig2 == 'S') {
            return -1;
        }
        return -3;
    }

    public int compare(Type other) {
        if (other instanceof PrimType) {
            return PrimType.compare(this, (PrimType)other);
        }
        if (!(other instanceof ClassType)) {
            return -3;
        }
        char sig1 = this.signature.charAt(0);
        String otherName = other.getName();
        switch (sig1) {
            case 'V': {
                return 1;
            }
            case 'D': {
                if (!otherName.equals("java.lang.Double") && !otherName.equals("gnu.math.DFloat")) break;
                return 0;
            }
            case 'I': {
                if (otherName.equals("java.lang.Integer")) {
                    return 0;
                }
                if (!otherName.equals("gnu.math.IntNum")) break;
                return -1;
            }
        }
        return -2;
    }

    public void emitCoerceFromObject(CodeAttr code) {
        int sig1;
        int n = sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        if (sig1 == 90) {
            code.emitCheckcast(Type.boolean_ctype);
            code.emitInvokeVirtual(Type.booleanValue_method);
        } else if (sig1 == 86) {
            code.emitPop(1);
        } else {
            code.emitCheckcast(Type.number_type);
            if (sig1 == 73 || sig1 == 83 || sig1 == 66) {
                code.emitInvokeVirtual(Type.intValue_method);
            } else if (sig1 == 74) {
                code.emitInvokeVirtual(Type.longValue_method);
            } else if (sig1 == 68) {
                code.emitInvokeVirtual(Type.doubleValue_method);
            } else if (sig1 == 70) {
                code.emitInvokeVirtual(Type.floatValue_method);
            } else {
                super.emitCoerceFromObject(code);
            }
        }
    }
}

