/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.Menu;
import gnu.jemacs.buffer.Window;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Frame
extends JFrame {
    static Frame selectedFrame;
    Window selectedWindow;
    JPanel contents;
    JMenuBar menuBar;
    static int counter;
    int id = ++counter;

    public Frame() {
        super(Frame.defaultName());
        ((Component)this).setSize(400, 300);
        if (selectedFrame == null) {
            selectedFrame = this;
        }
        this.setTitle("JEmacs");
    }

    public Frame(Buffer buffer) {
        Window window = new Window(buffer, true);
        window.frame = this;
        this.contents = window.wrap();
        this.getContentPane().add(this.contents);
        ((Component)this).setSize(600, 400);
        ((Component)this).setVisible(true);
        Window.setSelected(window);
        this.setTitle("JEmacs");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
    }

    public String ask(String string) {
        String string2 = JOptionPane.showInputDialog(this, (Object)string);
        if (string2 == null) {
            throw new CancelledException();
        }
        return string2;
    }

    public static String defaultName() {
        return "Emacs";
    }

    public void delete() {
        Window window = this.getFirstWindow();
        while (window != null) {
            Window window2 = window.getNextWindow(true);
            window.deleteNoValidate();
            window = window2;
        }
        this.contents = null;
        this.dispose();
        if (this == selectedFrame) {
            selectedFrame = null;
        }
    }

    public Window getFirstWindow() {
        return Window.getFirstWindow(this);
    }

    public Window getLastWindow() {
        return Window.getLastWindow(this);
    }

    public static Frame getSelectedFrame() {
        return selectedFrame;
    }

    public Window getSelectedWindow() {
        return this.selectedWindow;
    }

    public boolean isLive() {
        return this.contents != null;
    }

    public Window otherWindow(int n) {
        return this.selectedWindow.getNextWindowInFrame(n);
    }

    public void setMenuBar(Menu menu) {
        this.menuBar.removeAll();
        while (menu.getMenuComponentCount() > 0) {
            this.menuBar.add(menu.getMenuComponent(0));
        }
        this.menuBar.updateUI();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<frame #");
        stringBuffer.append(this.id);
        stringBuffer.append(" size: ");
        stringBuffer.append(this.getSize());
        stringBuffer.append(" preferred: ");
        stringBuffer.append(this.getPreferredSize());
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

