/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.mapping.WrongType;
import gnu.math.BitOps;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;

public class numbers
extends ModuleBody {
    static final numbers $instance = new numbers();
    public static final ModuleMethod isNumber;
    public static final ModuleMethod isQuantity;
    public static final ModuleMethod isComplex;
    public static final ModuleMethod isReal;
    public static final ModuleMethod isRational;
    public static final ModuleMethod isZero;
    public static final ModuleMethod isNegative;
    public static final ModuleMethod isOdd;
    public static final ModuleMethod isEven;
    public static final ModuleMethod abs;
    public static final ModuleMethod quotient;
    public static final ModuleMethod remainder;
    public static final ModuleMethod numerator;
    public static final ModuleMethod denominator;
    public static final ModuleMethod exp;
    public static final ModuleMethod log;
    public static final ModuleMethod sin;
    public static final ModuleMethod cos;
    public static final ModuleMethod tan;
    public static final ModuleMethod asin;
    public static final ModuleMethod acos;
    public static final ModuleMethod makeRectangular;
    public static final ModuleMethod makePolar;
    public static final ModuleMethod realPart;
    public static final ModuleMethod imagPart;
    public static final ModuleMethod magnitude;
    public static final ModuleMethod angle;
    public static final ModuleMethod lognot;
    public static final ModuleMethod logop;
    public static final ModuleMethod isLogbit;
    public static final ModuleMethod bitExtract;
    public static final ModuleMethod logtest;
    public static final ModuleMethod logcount;
    public static final ModuleMethod integerLength;

    /*
     * Enabled aggressive block sorting
     */
    static {
        integerLength = new ModuleMethod($instance, 1, "integer-length", 4097);
        logcount = new ModuleMethod($instance, 2, "logcount", 4097);
        logtest = new ModuleMethod($instance, 26, "logtest", 8194);
        bitExtract = new ModuleMethod($instance, 33, "bit-extract", 12291);
        isLogbit = new ModuleMethod($instance, 27, "logbit?", 8194);
        logop = new ModuleMethod($instance, 34, "logop", 12291);
        lognot = new ModuleMethod($instance, 3, "lognot", 4097);
        angle = new ModuleMethod($instance, 4, "angle", 4097);
        magnitude = new ModuleMethod($instance, 5, "magnitude", 4097);
        imagPart = new ModuleMethod($instance, 6, "imag-part", 4097);
        realPart = new ModuleMethod($instance, 7, "real-part", 4097);
        makePolar = new ModuleMethod($instance, 28, "make-polar", 8194);
        makeRectangular = new ModuleMethod($instance, 29, "make-rectangular", 8194);
        acos = new ModuleMethod($instance, 8, "acos", 4097);
        asin = new ModuleMethod($instance, 9, "asin", 4097);
        tan = new ModuleMethod($instance, 10, "tan", 4097);
        cos = new ModuleMethod($instance, 11, "cos", 4097);
        sin = new ModuleMethod($instance, 12, "sin", 4097);
        log = new ModuleMethod($instance, 13, "log", 4097);
        exp = new ModuleMethod($instance, 14, "exp", 4097);
        denominator = new ModuleMethod($instance, 15, "denominator", 4097);
        numerator = new ModuleMethod($instance, 30, "numerator", 8194);
        remainder = new ModuleMethod($instance, 31, "remainder", 8194);
        quotient = new ModuleMethod($instance, 32, "quotient", 8194);
        abs = new ModuleMethod($instance, 16, "abs", 4097);
        isEven = new ModuleMethod($instance, 17, "even?", 4097);
        isOdd = new ModuleMethod($instance, 18, "odd?", 4097);
        isNegative = new ModuleMethod($instance, 19, "negative?", 4097);
        isZero = new ModuleMethod($instance, 20, "zero?", 4097);
        isRational = new ModuleMethod($instance, 21, "rational?", 4097);
        isReal = new ModuleMethod($instance, 22, "real?", 4097);
        isComplex = new ModuleMethod($instance, 23, "complex?", 4097);
        isQuantity = new ModuleMethod($instance, 24, "quantity?", 4097);
        isNumber = new ModuleMethod($instance, 25, "number?", 4097);
        Object object2 = Interpreter.voidObject;
    }

    public static boolean isNumber(Object x) {
        return x instanceof Numeric;
    }

    public static boolean isQuantity(Object x) {
        return x instanceof Quantity;
    }

    public static boolean isComplex(Object x) {
        return x instanceof Complex;
    }

    public static boolean isReal(Object x) {
        return x instanceof RealNum;
    }

    public static boolean isRational(Object x) {
        return x instanceof RatNum;
    }

    public static boolean isZero(Numeric x) {
        return x.isZero();
    }

    public static boolean isNegative(RealNum x) {
        return x.isNegative();
    }

    public static boolean isOdd(IntNum x) {
        return x.isOdd();
    }

    public static boolean isEven(IntNum x) {
        return (numbers.isOdd(x) + 1 & 1) != 0;
    }

    public static Numeric abs(Numeric x) {
        return x.abs();
    }

    public static IntNum quotient(IntNum x, IntNum y) {
        return IntNum.quotient(x, y);
    }

    public static IntNum remainder(Object x, Object y) {
        IntNum intNum;
        try {
            intNum = (IntNum)x;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.math.IntNum.remainder(gnu.math.IntNum,gnu.math.IntNum)", 0);
        }
        try {
            return IntNum.remainder(intNum, (IntNum)y);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "gnu.math.IntNum.remainder(gnu.math.IntNum,gnu.math.IntNum)", 1);
        }
    }

    public static IntNum numerator(IntNum x, IntNum y) {
        return ((RatNum)x).numerator();
    }

    public static IntNum denominator(IntNum x) {
        return ((RatNum)x).denominator();
    }

    public static Complex exp(Complex x) {
        return x.exp();
    }

    public static Complex log(Complex x) {
        return x.log();
    }

    public static double sin(RealNum x) {
        try {
            return Math.sin(((Number)x).doubleValue());
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "java.lang.Math.sin(double)", 0);
        }
    }

    public static double cos(RealNum x) {
        return Math.cos(((Number)x).doubleValue());
    }

    public static double tan(RealNum x) {
        return Math.tan(((Number)x).doubleValue());
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static Complex makeRectangular(RealNum x, RealNum y) {
        return Complex.make(x, y);
    }

    public static DComplex makePolar(double x, double y) {
        return Complex.polar(x, y);
    }

    public static RealNum realPart(Complex x) {
        return x.re();
    }

    public static Quantity imagPart(Complex x) {
        return Quantity.make(x.im(), x.unit());
    }

    public static Numeric magnitude(Numeric x) {
        return x.abs();
    }

    public static RealNum angle(Complex x) {
        return ((Quantity)x).number().angle();
    }

    public static IntNum lognot(IntNum i) {
        return BitOps.not(i);
    }

    public static IntNum logop(int op, IntNum i, IntNum j) {
        return BitOps.bitOp(op, i, j);
    }

    public static boolean isLogbit(IntNum i, int bitno) {
        return BitOps.bitValue(i, bitno);
    }

    public static IntNum bitExtract(IntNum i, int start, int end) {
        return BitOps.extract(i, start, end);
    }

    public static boolean logtest(IntNum i, IntNum j) {
        return BitOps.test(i, j);
    }

    public static int logcount(IntNum i) {
        return BitOps.bitCount(i);
    }

    public static int integerLength(IntNum i) {
        return i.intLength();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return IntNum.make(numbers.integerLength((IntNum)object2));
            }
            case 2: {
                return IntNum.make(numbers.logcount((IntNum)object2));
            }
            case 3: {
                return numbers.lognot((IntNum)object2);
            }
            case 4: {
                return numbers.angle((Complex)object2);
            }
            case 5: {
                return numbers.magnitude((Numeric)object2);
            }
            case 6: {
                return numbers.imagPart((Complex)object2);
            }
            case 7: {
                return numbers.realPart((Complex)object2);
            }
            case 8: {
                return DFloNum.make(numbers.acos(((Number)object2).doubleValue()));
            }
            case 9: {
                return DFloNum.make(numbers.asin(((Number)object2).doubleValue()));
            }
            case 10: {
                return DFloNum.make(numbers.tan((RealNum)object2));
            }
            case 11: {
                return DFloNum.make(numbers.cos((RealNum)object2));
            }
            case 12: {
                return DFloNum.make(numbers.sin((RealNum)object2));
            }
            case 13: {
                return numbers.log((Complex)object2);
            }
            case 14: {
                return numbers.exp((Complex)object2);
            }
            case 15: {
                return numbers.denominator((IntNum)object2);
            }
            case 16: {
                return numbers.abs((Numeric)object2);
            }
            case 17: {
                Boolean bl;
                if (numbers.isEven((IntNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 18: {
                Boolean bl;
                if (numbers.isOdd((IntNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 19: {
                Boolean bl;
                if (numbers.isNegative((RealNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 20: {
                Boolean bl;
                if (numbers.isZero((Numeric)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 21: {
                Boolean bl;
                if (numbers.isRational(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 22: {
                Boolean bl;
                if (numbers.isReal(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 23: {
                Boolean bl;
                if (numbers.isComplex(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 24: {
                Boolean bl;
                if (numbers.isQuantity(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 25: {
                Boolean bl;
                if (numbers.isNumber(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "zero?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "negative?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "odd?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "even?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "abs", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "denominator", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "exp", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "log", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "sin", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "cos", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "tan", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "asin", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "acos", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "real-part", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "imag-part", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "magnitude", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "angle", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "lognot", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logcount", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "integer-length", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 26: {
                Boolean bl;
                IntNum intNum = (IntNum)object2;
                if (numbers.logtest(intNum, (IntNum)object3)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 27: {
                Boolean bl;
                IntNum intNum = (IntNum)object2;
                if (numbers.isLogbit(intNum, ((Number)object3).intValue())) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 28: {
                double d = ((Number)object2).doubleValue();
                return numbers.makePolar(d, ((Number)object3).doubleValue());
            }
            case 29: {
                RealNum realNum = (RealNum)object2;
                return numbers.makeRectangular(realNum, (RealNum)object3);
            }
            case 30: {
                IntNum intNum = (IntNum)object2;
                return numbers.numerator(intNum, (IntNum)object3);
            }
            case 31: {
                return numbers.remainder(object2, object3);
            }
            case 32: {
                IntNum intNum = (IntNum)object2;
                return numbers.quotient(intNum, (IntNum)object3);
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "quotient", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "quotient", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "numerator", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "numerator", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-rectangular", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-rectangular", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-polar", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-polar", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logbit?", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logbit?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logtest", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logtest", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 33: {
                IntNum intNum = (IntNum)object2;
                int n = ((Number)object3).intValue();
                return numbers.bitExtract(intNum, n, ((Number)object4).intValue());
            }
            case 34: {
                int n = ((Number)object2).intValue();
                IntNum intNum = (IntNum)object3;
                return numbers.logop(n, intNum, (IntNum)object4);
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 0);
        }
    }
}

