/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.BaseUnit;
import gnu.math.Unit;

public class Dimensions {
    BaseUnit[] bases;
    short[] powers;
    int hash_code;
    private Dimensions chain;
    private static Dimensions[] hashTable = new Dimensions[100];
    public static Dimensions Empty = new Dimensions();

    private Dimensions() {
        this.bases = new BaseUnit[1];
        this.bases[0] = Unit.Empty;
        this.enterHash(0);
    }

    Dimensions(BaseUnit baseUnit) {
        this.bases = new BaseUnit[2];
        this.powers = new short[1];
        this.bases[0] = baseUnit;
        this.bases[1] = Unit.Empty;
        this.powers[0] = 1;
        this.enterHash(baseUnit.index);
    }

    private Dimensions(Dimensions dimensions, int n, Dimensions dimensions2, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        this.hash_code = n3;
        n4 = 0;
        while (dimensions.bases[n4] != Unit.Empty) {
            ++n4;
        }
        n5 = 0;
        while (dimensions2.bases[n5] != Unit.Empty) {
            ++n5;
        }
        int n6 = n4 + n5 + 1;
        this.bases = new BaseUnit[n6];
        this.powers = new short[n6];
        n6 = 0;
        n5 = 0;
        n4 = 0;
        while (true) {
            int n7;
            BaseUnit baseUnit = dimensions.bases[n4];
            BaseUnit baseUnit2 = dimensions2.bases[n5];
            if (baseUnit.index < baseUnit2.index) {
                n7 = dimensions.powers[n4] * n;
                ++n4;
            } else if (baseUnit2.index < baseUnit.index) {
                baseUnit = baseUnit2;
                n7 = dimensions2.powers[n5] * n2;
                ++n5;
            } else {
                if (baseUnit2 == Unit.Empty) break;
                n7 = dimensions.powers[n4] * n + dimensions2.powers[n5] * n2;
                ++n4;
                ++n5;
                if (n7 == 0) continue;
            }
            if ((short)n7 != n7) {
                throw new ArithmeticException("overflow in dimensions");
            }
            this.bases[n6] = baseUnit;
            this.powers[n6++] = (short)n7;
        }
        this.bases[n6] = Unit.Empty;
        this.enterHash(n3);
    }

    private void enterHash(int n) {
        this.hash_code = n;
        int n2 = (n & Integer.MAX_VALUE) % hashTable.length;
        this.chain = hashTable[n2];
        Dimensions.hashTable[n2] = this;
    }

    public int getPower(BaseUnit baseUnit) {
        int n = 0;
        while (this.bases[n].index <= baseUnit.index) {
            if (this.bases[n] == baseUnit) {
                return this.powers[n];
            }
            ++n;
        }
        return 0;
    }

    public final int hashCode() {
        return this.hash_code;
    }

    private boolean matchesProduct(Dimensions dimensions, int n, Dimensions dimensions2, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6;
            BaseUnit baseUnit = dimensions.bases[n3];
            BaseUnit baseUnit2 = dimensions2.bases[n4];
            if (baseUnit.index < baseUnit2.index) {
                n6 = dimensions.powers[n3] * n;
                ++n3;
            } else if (baseUnit2.index < baseUnit.index) {
                baseUnit = baseUnit2;
                n6 = dimensions2.powers[n4] * n2;
                ++n4;
            } else {
                if (baseUnit2 == Unit.Empty) {
                    return this.bases[n5] == baseUnit2;
                }
                n6 = dimensions.powers[n3] * n + dimensions2.powers[n4] * n2;
                ++n3;
                ++n4;
                if (n6 == 0) continue;
            }
            if (this.bases[n5] != baseUnit || this.powers[n5] != n6) {
                return false;
            }
            ++n5;
        }
    }

    public static Dimensions product(Dimensions dimensions, int n, Dimensions dimensions2, int n2) {
        int n3 = dimensions.hashCode() * n + dimensions2.hashCode() * n2;
        int n4 = (n3 & Integer.MAX_VALUE) % hashTable.length;
        Dimensions dimensions3 = hashTable[n4];
        while (dimensions3 != null) {
            if (dimensions3.hash_code == n3 && dimensions3.matchesProduct(dimensions, n, dimensions2, n2)) {
                return dimensions3;
            }
            dimensions3 = dimensions3.chain;
        }
        return new Dimensions(dimensions, n, dimensions2, n2, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.bases[n] != Unit.Empty) {
            if (n > 0) {
                stringBuffer.append('*');
            }
            stringBuffer.append(this.bases[n]);
            short s = this.powers[n];
            if (s != 1) {
                stringBuffer.append('^');
                stringBuffer.append(s);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

