/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class TtyInPort
extends InPort {
    protected OutPort tie;
    private Procedure prompter;
    private boolean promptEmitted;

    public TtyInPort(InputStream inputStream, String string, OutPort outPort) {
        super(inputStream, string);
        this.setConvertCR(true);
        this.tie = outPort;
    }

    public TtyInPort(Reader reader, String string, OutPort outPort) {
        super(reader, string);
        this.setConvertCR(true);
        this.tie = outPort;
    }

    public int fill(int n) throws IOException {
        int n2 = this.in.read(this.buffer, this.pos, n);
        if (this.tie != null && n2 > 0) {
            this.tie.echo(this.buffer, this.pos, n2);
        }
        return n2;
    }

    public Procedure getPrompter() {
        return this.prompter;
    }

    public void lineStart(boolean bl) throws IOException {
        if (!bl && this.prompter != null) {
            try {
                String string;
                Object object2 = this.prompter.apply1(this);
                if (object2 != null && (string = object2.toString()) != null && string.length() > 0) {
                    this.tie.print(string);
                    this.tie.flush();
                    this.promptEmitted = true;
                }
            }
            catch (Exception exception) {
                throw new IOException("Error when evaluating prompt:" + exception);
            }
        }
    }

    public int read() throws IOException {
        int n;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((n = super.read()) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.tie != null) {
            this.tie.flush();
        }
        if ((n3 = super.read(cArray, n, n2)) < 0 && this.promptEmitted & this.tie != null) {
            this.tie.println();
        }
        this.promptEmitted = false;
        return n3;
    }

    public void setPrompter(Procedure procedure) {
        this.prompter = procedure;
    }
}

