/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IntFraction
extends RatNum
implements Externalizable {
    IntNum num;
    IntNum den;

    IntFraction() {
    }

    public IntFraction(IntNum intNum, IntNum intNum2) {
        this.num = intNum;
        this.den = intNum2;
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof RatNum) {
            return RatNum.add(this, (RatNum)object2, n);
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (!(numeric instanceof RatNum)) {
            throw new IllegalArgumentException();
        }
        return RatNum.add((RatNum)numeric, this, n);
    }

    public final int compare(Object object2) {
        if (object2 instanceof RatNum) {
            return RatNum.compare(this, (RatNum)object2);
        }
        if (!(object2 instanceof RealNum)) {
            throw new IllegalArgumentException();
        }
        return ((RealNum)object2).compareReversed(this);
    }

    public int compareReversed(Numeric numeric) {
        if (!(numeric instanceof RatNum)) {
            throw new IllegalArgumentException();
        }
        return RatNum.compare((RatNum)numeric, this);
    }

    public final IntNum denominator() {
        return this.den;
    }

    public Numeric div(Object object2) {
        if (object2 instanceof RatNum) {
            return RatNum.divide(this, (RatNum)object2);
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).divReversed(this);
    }

    public Numeric divReversed(Numeric numeric) {
        if (!(numeric instanceof RatNum)) {
            throw new IllegalArgumentException();
        }
        return RatNum.divide((RatNum)numeric, this);
    }

    public double doubleValue() {
        boolean bl = this.num.isNegative();
        IntNum intNum = this.num;
        if (bl) {
            intNum = IntNum.neg(intNum);
        }
        int n = intNum.intLength();
        int n2 = this.den.intLength();
        int n3 = 0;
        if (n < n2 + 54) {
            n3 = n2 + 54 - n;
            intNum = IntNum.shift(intNum, n3);
            n3 = -n3;
        }
        IntNum intNum2 = new IntNum();
        IntNum intNum3 = new IntNum();
        IntNum.divide(intNum, this.den, intNum2, intNum3, 3);
        intNum2 = intNum2.canonicalize();
        intNum3 = intNum3.canonicalize();
        return intNum2.roundToDouble(n3, bl, intNum3.isZero() ^ true);
    }

    public final boolean isNegative() {
        return this.num.isNegative();
    }

    public long longValue() {
        return this.toExactInt(4).longValue();
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof RatNum) {
            return RatNum.times(this, (RatNum)object2);
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (!(numeric instanceof RatNum)) {
            throw new IllegalArgumentException();
        }
        return RatNum.times((RatNum)numeric, this);
    }

    public Numeric neg() {
        return IntFraction.neg(this);
    }

    public static IntFraction neg(IntFraction intFraction) {
        return new IntFraction(IntNum.neg(intFraction.numerator()), intFraction.denominator());
    }

    public final IntNum numerator() {
        return this.num;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.num = (IntNum)objectInput.readObject();
        this.den = (IntNum)objectInput.readObject();
    }

    public final int sign() {
        return this.num.sign();
    }

    public String toString(int n) {
        return String.valueOf(this.num.toString(n)) + '/' + this.den.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.num);
        objectOutput.writeObject(this.den);
    }
}

