/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import gnu.math.MPN;

public class BitOps {
    static final byte[] bit4_count;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        bit4_count = byArray;
    }

    private BitOps() {
    }

    public static IntNum and(IntNum intNum, int n) {
        if (intNum.words == null) {
            return IntNum.make(intNum.ival & n);
        }
        if (n >= 0) {
            return IntNum.make(intNum.words[0] & n);
        }
        int n2 = intNum.ival;
        int[] nArray = new int[n2];
        nArray[0] = intNum.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = intNum.words[n2];
        }
        return IntNum.make(nArray, intNum.ival);
    }

    public static IntNum and(IntNum intNum, IntNum intNum2) {
        if (intNum2.words == null) {
            return BitOps.and(intNum, intNum2.ival);
        }
        if (intNum.words == null) {
            return BitOps.and(intNum2, intNum.ival);
        }
        if (intNum.ival < intNum2.ival) {
            IntNum intNum3 = intNum;
            intNum = intNum2;
            intNum2 = intNum3;
        }
        int n = intNum2.isNegative() ? intNum.ival : intNum2.ival;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < intNum2.ival) {
            nArray[n2] = intNum.words[n2] & intNum2.words[n2];
            ++n2;
        }
        while (n2 < n) {
            nArray[n2] = intNum.words[n2];
            ++n2;
        }
        return IntNum.make(nArray, n);
    }

    public static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    public static int bitCount(IntNum intNum) {
        int n;
        int n2;
        int[] nArray = intNum.words;
        if (nArray == null) {
            n2 = 1;
            n = BitOps.bitCount(intNum.ival);
        } else {
            n2 = intNum.ival;
            n = BitOps.bitCount(nArray, n2);
        }
        return intNum.isNegative() ? n2 * 32 - n : n;
    }

    public static int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BitOps.bitCount(nArray[n]);
        }
        return n2;
    }

    public static IntNum bitOp(int n, IntNum intNum, IntNum intNum2) {
        switch (n) {
            case 0: {
                return IntNum.zero();
            }
            case 1: {
                return BitOps.and(intNum, intNum2);
            }
            case 3: {
                return intNum;
            }
            case 5: {
                return intNum2;
            }
            case 15: {
                return IntNum.minusOne();
            }
        }
        IntNum intNum3 = new IntNum();
        BitOps.setBitOp(intNum3, n, intNum, intNum2);
        return intNum3.canonicalize();
    }

    public static boolean bitValue(IntNum intNum, int n) {
        int n2 = intNum.ival;
        if (intNum.words == null) {
            return n >= 32 ? n2 < 0 : (n2 >> n & 1) != 0;
        }
        int n3 = n >> 5;
        return n3 >= n2 ? intNum.words[n2 - 1] < 0 : (intNum.words[n3] >> n & 1) != 0;
    }

    public static IntNum extract(IntNum intNum, int n, int n2) {
        int n3;
        int n4;
        if (n2 < 32) {
            int n5 = intNum.words == null ? intNum.ival : intNum.words[0];
            return IntNum.make((n5 & ~(-1 << n2)) >> n);
        }
        if (intNum.words == null) {
            if (intNum.ival >= 0) {
                return IntNum.make(n >= 31 ? 0 : intNum.ival >> n);
            }
            n4 = 1;
        } else {
            n4 = intNum.ival;
        }
        boolean bl = intNum.isNegative();
        if (n2 > 32 * n4) {
            n2 = 32 * n4;
            if (!bl && n == 0) {
                return intNum;
            }
        } else {
            n4 = n2 + 31 >> 5;
        }
        if ((n3 = n2 - n) < 64) {
            long l = intNum.words == null ? (long)(intNum.ival >> (n >= 32 ? 31 : n)) : MPN.rshift_long(intNum.words, n4, n);
            return IntNum.make(l & (-1L << n3 ^ 0xFFFFFFFFFFFFFFFFL));
        }
        int n6 = n >> 5;
        int n7 = (n2 >> 5) + 1 - n6;
        int[] nArray = new int[n7];
        if (intNum.words == null) {
            nArray[0] = n >= 32 ? -1 : intNum.ival >> n;
        } else {
            MPN.rshift0(nArray, intNum.words, n6, n4 -= n6, n &= 0x1F);
        }
        int n8 = n4 = n3 >> 5;
        nArray[n8] = nArray[n8] & ~(-1 << n3);
        return IntNum.make(nArray, n4 + 1);
    }

    public static IntNum ior(IntNum intNum, IntNum intNum2) {
        return BitOps.bitOp(7, intNum, intNum2);
    }

    public static IntNum not(IntNum intNum) {
        return BitOps.bitOp(12, intNum, IntNum.zero());
    }

    public static void setBitOp(IntNum intNum, int n, IntNum intNum2, IntNum intNum3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (intNum3.words != null && (intNum2.words == null || intNum2.ival < intNum3.ival)) {
            IntNum intNum4 = intNum2;
            intNum2 = intNum3;
            intNum3 = intNum4;
            n = BitOps.swappedOp(n);
        }
        if (intNum3.words == null) {
            n6 = intNum3.ival;
            n5 = 1;
        } else {
            n6 = intNum3.words[0];
            n5 = intNum3.ival;
        }
        if (intNum2.words == null) {
            n4 = intNum2.ival;
            n3 = 1;
        } else {
            n4 = intNum2.words[0];
            n3 = intNum2.ival;
        }
        if (n3 > 1) {
            intNum.realloc(n3);
        }
        int[] nArray = intNum.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                n8 = n6 < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                n8 = n6 >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = intNum2.words[n7];
                    n6 = intNum3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    intNum.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = intNum2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~intNum2.words[n7];
                }
                break;
            }
        }
        intNum.ival = n7;
    }

    public static int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    public static boolean test(IntNum intNum, int n) {
        if (intNum.words == null) {
            return (intNum.ival & n) != 0;
        }
        return n < 0 || (intNum.words[0] & n) != 0;
    }

    public static boolean test(IntNum intNum, IntNum intNum2) {
        if (intNum2.words == null) {
            return BitOps.test(intNum, intNum2.ival);
        }
        if (intNum.words == null) {
            return BitOps.test(intNum2, intNum.ival);
        }
        if (intNum.ival < intNum2.ival) {
            IntNum intNum3 = intNum;
            intNum = intNum2;
            intNum2 = intNum3;
        }
        int n = 0;
        while (n < intNum2.ival) {
            if ((intNum.words[n] & intNum2.words[n]) != 0) {
                return true;
            }
            ++n;
        }
        return intNum2.isNegative();
    }

    public static IntNum xor(IntNum intNum, IntNum intNum2) {
        return BitOps.bitOp(6, intNum, intNum2);
    }
}

