/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class U8Vector
extends UniformVector
implements Externalizable {
    byte[] data;

    public U8Vector() {
    }

    public U8Vector(int n) {
        this.data = new byte[n];
    }

    public U8Vector(int n, byte by) {
        byte[] byArray = new byte[n];
        this.data = byArray;
        while (--n >= 0) {
            byArray[n] = by;
        }
    }

    public U8Vector(Sequence sequence) {
        this.data = new byte[sequence.length()];
        this.copy(sequence);
    }

    public U8Vector(byte[] byArray) {
        this.data = byArray;
    }

    public final Object get(int n) {
        return IntNum.make(this.data[n] & 0xFF);
    }

    public final String getTag() {
        return "s8";
    }

    public final int intValue(int n) {
        return this.data[n] & 0xFF;
    }

    public final int length() {
        return this.data.length;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.intValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = objectInput.readByte();
            ++n2;
        }
        this.data = byArray;
    }

    public final void set(int n, byte by) {
        this.data[n] = by;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = (byte)((Number)object2).intValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeByte(this.data[n2]);
            ++n2;
        }
    }
}

