/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DFloNum
extends RealNum
implements Externalizable {
    double value;
    private static final DFloNum one = new DFloNum(1.0);

    public DFloNum() {
    }

    public DFloNum(double d) {
        this.value = d;
    }

    public DFloNum(String string) throws NumberFormatException {
        Double d = Double.valueOf(string);
        this.value = d;
        if (this.value == 0.0 && string.charAt(0) == '-') {
            this.value = -0.0;
        }
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof RealNum) {
            return new DFloNum(this.value + (double)n * ((RealNum)object2).doubleValue());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (numeric instanceof RealNum) {
            return new DFloNum(((RealNum)numeric).doubleValue() + (double)n * this.value);
        }
        throw new IllegalArgumentException();
    }

    public static int compare(double d, double d2) {
        return d > d2 ? 1 : (d < d2 ? -1 : (d == d2 ? 0 : -2));
    }

    public static int compare(IntNum intNum, IntNum intNum2, double d) {
        if (Double.isNaN(d)) {
            return -2;
        }
        if (Double.isInfinite(d)) {
            int n;
            int n2 = n = d >= 0.0 ? -1 : 1;
            if (!intNum2.isZero()) {
                return n;
            }
            if (intNum.isZero()) {
                return -2;
            }
            return intNum.isNegative() ? n : ~(n >>= 1);
        }
        long l = Double.doubleToLongBits(d);
        boolean bl = l < 0L;
        int n = (int)(l >> 52) & 0x7FF;
        l &= 0xFFFFFFFFFFFFFL;
        l = n == 0 ? (l <<= 1) : (l |= 0x10000000000000L);
        IntNum intNum3 = IntNum.make(bl ? -l : l);
        if (n >= 1075) {
            intNum3 = IntNum.shift(intNum3, n - 1075);
        } else {
            intNum = IntNum.shift(intNum, 1075 - n);
        }
        return IntNum.compare(intNum, IntNum.times(intNum3, intNum2));
    }

    public int compare(Object object2) {
        if (object2 instanceof RatNum) {
            RatNum ratNum = (RatNum)object2;
            int n = DFloNum.compare(ratNum.numerator(), ratNum.denominator(), this.value);
            return n < -1 ? n : -n;
        }
        if (object2 instanceof RealNum) {
            return DFloNum.compare(this.value, ((RealNum)object2).doubleValue());
        }
        if (!(object2 instanceof RealNum)) {
            throw new IllegalArgumentException();
        }
        return ((RealNum)object2).compareReversed(this);
    }

    public int compareReversed(Numeric numeric) {
        if (!(numeric instanceof RealNum)) {
            throw new IllegalArgumentException();
        }
        if (numeric instanceof RatNum) {
            RatNum ratNum = (RatNum)numeric;
            return DFloNum.compare(ratNum.numerator(), ratNum.denominator(), this.value);
        }
        return DFloNum.compare(((RealNum)numeric).doubleValue(), this.value);
    }

    public Numeric div(Object object2) {
        if (object2 instanceof RealNum) {
            return new DFloNum(this.value / ((RealNum)object2).doubleValue());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).divReversed(this);
    }

    public Numeric divReversed(Numeric numeric) {
        if (numeric instanceof RealNum) {
            return new DFloNum(((RealNum)numeric).doubleValue() / this.value);
        }
        throw new IllegalArgumentException();
    }

    public final double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object2) {
        return object2 != null && object2 instanceof DFloNum && Double.doubleToLongBits(((DFloNum)object2).value) == Double.doubleToLongBits(this.value);
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean isExact() {
        return false;
    }

    public boolean isNegative() {
        return this.value < 0.0;
    }

    public boolean isZero() {
        return this.value == 0.0;
    }

    public long longValue() {
        return (long)this.value;
    }

    public static DFloNum make(double d) {
        return new DFloNum(d);
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof RealNum) {
            return new DFloNum(this.value * ((RealNum)object2).doubleValue());
        }
        if (!(object2 instanceof Numeric)) {
            throw new IllegalArgumentException();
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (numeric instanceof RealNum) {
            return new DFloNum(((RealNum)numeric).doubleValue() * this.value);
        }
        throw new IllegalArgumentException();
    }

    public Numeric neg() {
        return new DFloNum(-this.value);
    }

    public static final DFloNum one() {
        return one;
    }

    public Numeric power(IntNum intNum) {
        return new DFloNum(Math.pow(this.doubleValue(), intNum.doubleValue()));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = objectInput.readDouble();
    }

    public int sign() {
        return this.value > 0.0 ? 1 : (this.value < 0.0 ? -1 : (this.value == 0.0 ? 0 : -2));
    }

    public static RatNum toExact(double d) {
        if (Double.isInfinite(d)) {
            return RatNum.infinity(d >= 0.0 ? 1 : -1);
        }
        if (Double.isNaN(d)) {
            throw new ArithmeticException("cannot convert NaN to exact rational");
        }
        long l = Double.doubleToLongBits(d);
        boolean bl = l < 0L;
        int n = (int)(l >> 52) & 0x7FF;
        l &= 0xFFFFFFFFFFFFFL;
        l = n == 0 ? (l <<= 1) : (l |= 0x10000000000000L);
        IntNum intNum = IntNum.make(bl ? -l : l);
        if (n >= 1075) {
            return IntNum.shift(intNum, n - 1075);
        }
        return RatNum.make(intNum, IntNum.shift(IntNum.one(), 1075 - n));
    }

    public String toString() {
        return this.value == Double.POSITIVE_INFINITY ? "#i1/0" : (this.value == Double.NEGATIVE_INFINITY ? "#i-1/0" : (Double.isNaN(this.value) ? "#i0/0" : Double.toString(this.value)));
    }

    public String toString(int n) {
        if (n == 10) {
            return this.toString();
        }
        return "#d" + this.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.value);
    }
}

