/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import java.lang.reflect.Field;

public class GetFieldProc
extends Procedure1
implements Inlineable {
    ClassType ctype;
    gnu.bytecode.Field field;

    public GetFieldProc(ClassType classType, String string) {
        this.ctype = classType;
        this.field = gnu.bytecode.Field.searchField(classType.getFields(), string);
    }

    public GetFieldProc(ClassType classType, String string, Type type, int n) {
        this.ctype = classType;
        this.field = classType.getField(string);
        if (this.field == null) {
            this.field = classType.addField(string, type, n);
        }
    }

    public GetFieldProc(Class clazz, String string) {
        this((ClassType)Type.make(clazz), string);
    }

    public Object apply1(Object object2) {
        try {
            Field field = this.field.getReflectField();
            return field.get(object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("no such field " + this.field.getSourceName() + " in " + this.ctype.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("illegal access for field " + this.field.getSourceName());
        }
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        ClassLoader classLoader = this.ctype.getReflectClass().getClassLoader();
        if (classLoader instanceof ArrayClassLoader) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        applyExp.getArgs()[0].compile(compilation, this.ctype);
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitGetField(this.field);
        target.compileFromStack(compilation, this.field.getType());
    }

    private gnu.bytecode.Field getField() {
        return this.field;
    }

    public Type getReturnType(Expression[] expressionArray) {
        return this.getField().getType();
    }
}

