/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.BaseUnit;
import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.DQuantity;
import gnu.math.Dimensions;
import gnu.math.IntNum;
import gnu.math.MulUnit;
import gnu.math.NamedUnit;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RealNum;

public abstract class Unit
extends Quantity {
    Dimensions dims;
    double factor = 1.0;
    MulUnit products;
    Unit base;
    static NamedUnit[] table = new NamedUnit[100];
    public static BaseUnit Empty;
    public static final BaseUnit meter;
    public static final BaseUnit second;
    public static final BaseUnit gram;
    public static final Unit cm;
    public static final Unit mm;
    public static final Unit in;
    public static final Unit pt;
    public static final Unit pica;
    public static final Unit radian;
    public static final Unit minute;
    public static final Unit hour;

    static {
        Dimensions.Empty.bases[0] = Empty = new BaseUnit();
        meter = new BaseUnit("m", "Length");
        second = new BaseUnit("s", "Time");
        gram = new BaseUnit("g", "Mass");
        cm = Unit.define("cm", 0.01, meter);
        mm = Unit.define("mm", 0.1, cm);
        in = Unit.define("in", 0.0254, meter);
        pt = Unit.define("pt", 3.527778E-4, meter);
        pica = Unit.define("pica", 0.004233333, meter);
        radian = Unit.define("rad", 1.0, Empty);
        minute = Unit.define("min", 60.0, second);
        hour = Unit.define("hour", 60.0, minute);
    }

    Unit() {
    }

    public static Unit define(String string, double d, Unit unit) {
        return new NamedUnit(string, d, unit);
    }

    public static Unit define(String string, DQuantity dQuantity) {
        return new NamedUnit(string, dQuantity);
    }

    public final Dimensions dimensions() {
        return this.dims;
    }

    public static Unit div(Unit unit, Unit unit2) {
        return Unit.mul(unit, 1, unit2, -1);
    }

    public final double doubleValue() {
        return this.factor;
    }

    public String getName() {
        return null;
    }

    public int hashCode() {
        return this.dims.hashCode();
    }

    public boolean isExact() {
        return false;
    }

    public final boolean isZero() {
        return false;
    }

    public static NamedUnit lookup(String string) {
        return NamedUnit.lookup(string);
    }

    public static NamedUnit make(String string, Quantity quantity) {
        return NamedUnit.make(string, quantity);
    }

    static Unit mul(Unit unit, int n, Unit unit2, int n2) {
        MulUnit mulUnit;
        if (unit == unit2) {
            n += n2;
            unit2 = Empty;
            n2 = 0;
        }
        if (n == 0 || unit == Empty) {
            unit = unit2;
            n = n2;
            unit2 = Empty;
            n2 = 0;
        }
        if (n2 == 0 || unit2 == Empty) {
            if (n == 1) {
                return unit;
            }
            if (n == 0) {
                return Empty;
            }
        }
        if (unit instanceof MulUnit) {
            mulUnit = (MulUnit)unit;
            if (mulUnit.unit1 == unit2) {
                return Unit.mul(unit2, mulUnit.power1 * n + n2, mulUnit.unit2, mulUnit.power2 * n);
            }
            if (mulUnit.unit2 == unit2) {
                return Unit.mul(mulUnit.unit1, mulUnit.power1 * n, unit2, mulUnit.power2 * n + n2);
            }
            if (unit2 instanceof MulUnit) {
                MulUnit mulUnit2 = (MulUnit)unit2;
                if (mulUnit.unit1 == mulUnit2.unit1 && mulUnit.unit2 == mulUnit2.unit2) {
                    return Unit.mul(mulUnit.unit1, mulUnit.power1 * n + mulUnit2.power1 * n2, mulUnit.unit2, mulUnit.power2 * n + mulUnit2.power2 * n2);
                }
                if (mulUnit.unit1 == mulUnit2.unit2 && mulUnit.unit2 == mulUnit2.unit1) {
                    return Unit.mul(mulUnit.unit1, mulUnit.power1 * n + mulUnit2.power2 * n2, mulUnit.unit2, mulUnit.power2 * n + mulUnit2.power1 * n2);
                }
            }
        }
        if (unit2 instanceof MulUnit) {
            mulUnit = (MulUnit)unit2;
            if (mulUnit.unit1 == unit) {
                return Unit.mul(unit, n + mulUnit.power1 * n2, mulUnit.unit2, mulUnit.power2 * n2);
            }
            if (mulUnit.unit2 == unit) {
                return Unit.mul(mulUnit.unit1, mulUnit.power1 * n2, unit, n + mulUnit.power2 * n2);
            }
        }
        return MulUnit.make(unit, n, unit2, n2);
    }

    public static Unit mul(Unit unit, Unit unit2) {
        return Unit.mul(unit, 1, unit2, 1);
    }

    public Complex number() {
        return DFloNum.one();
    }

    public static Unit pow(Unit unit, int n) {
        return Unit.mul(unit, n, Empty, 0);
    }

    public Numeric power(IntNum intNum) {
        if (intNum.words != null) {
            throw new ArithmeticException("Unit raised to bignum power");
        }
        return Unit.pow(this, intNum.ival);
    }

    public Unit sqrt() {
        if (this == Empty) {
            return this;
        }
        throw new RuntimeException("unimplemented Unit.sqrt");
    }

    public String toString() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        if (this == Empty) {
            return "unit";
        }
        return String.valueOf(Double.toString(this.factor)) + "<unnamed unit>";
    }

    public String toString(double d) {
        String string = Double.toString(d);
        if (this == Empty) {
            return string;
        }
        return String.valueOf(string) + this.toString();
    }

    public String toString(RealNum realNum) {
        return this.toString(realNum.doubleValue());
    }

    public Unit unit() {
        return this;
    }
}

