/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ChainLambdas;
import gnu.expr.CheckedTarget;
import gnu.expr.ConditionalTarget;
import gnu.expr.Expression;
import gnu.expr.FindCapturedVars;
import gnu.expr.FindTailCalls;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.LitTable;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.PushApply;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.Undefined;
import gnu.kawa.util.LList;
import gnu.mapping.Values;
import gnu.text.SourceError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Compilation {
    Vector applyMethods = new Vector();
    int maxSelectorValue;
    public ClassType curClass;
    public ClassType mainClass;
    public LambdaExp curLambda;
    public Variable thisDecl;
    Field instanceField;
    public static boolean fewerClasses;
    public static boolean usingCPStyle;
    public static boolean usingTailCalls;
    public static int moduleStatic;
    ClassType[] classes;
    int numClasses;
    boolean immediate;
    public Method method;
    int method_counter;
    SwitchState fswitch;
    Field fswitchIndex;
    Variable callStackContext;
    public static ClassType typeObject;
    public static ClassType scmBooleanType;
    public static ClassType typeString;
    public static ClassType javaStringType;
    public static ClassType scmSymbolType;
    public static ClassType scmKeywordType;
    public static ClassType scmSequenceType;
    public static ClassType javaIntegerType;
    public static ClassType scmListType;
    public static ClassType typePair;
    public static ClassType scmPairType;
    public static ClassType scmUndefinedType;
    public static final ArrayType objArrayType;
    public static final ArrayType symbolArrayType;
    public static ClassType scmNamedType;
    public static ClassType typeRunnable;
    public static ClassType typeProcedure;
    public static ClassType typeInterpreter;
    public static ClassType typeMacro;
    public static ClassType typeEnvironment;
    public static ClassType typeLocation;
    public static ClassType typeBinding;
    public static ClassType typeBinding2;
    static final Field functionValueBinding2Field;
    public static final Method getLocationMethod;
    public static final Method getProcedureBindingMethod;
    public static final Field trueConstant;
    public static final Field falseConstant;
    static final Field voidConstant;
    static final Field undefinedConstant;
    static final Field emptyConstant;
    static final Method setNameMethod;
    static Method initIntegerMethod;
    static Method lookupGlobalMethod;
    static Method defineGlobalMethod;
    static Method defineFunctionMethod;
    static Method putGlobalMethod;
    static Method makeListMethod;
    public static final Type[] int1Args;
    public static final Type[] string1Arg;
    public static final Type[] sym1Arg;
    public static final Method getBindingEnvironmentMethod;
    public static final Method getBinding2Method;
    public static Method getCurrentEnvironmentMethod;
    public static Type[] apply0args;
    public static Type[] apply1args;
    public static Type[] apply2args;
    public static Type[] applyNargs;
    static Method checkArgCountMethod;
    public static Method apply0method;
    public static Method apply1method;
    public static Method apply2method;
    public static Method apply3method;
    public static Method apply4method;
    public static Method applyNmethod;
    public static Method[] applymethods;
    public static ClassType typeProcedure0;
    public static ClassType typeProcedure1;
    public static ClassType typeProcedure2;
    public static ClassType typeProcedure3;
    public static ClassType typeProcedure4;
    public static ClassType typeProcedureN;
    public static ClassType typeModuleBody;
    public static ClassType typeApplet;
    public static ClassType typeModuleMethod;
    public static ClassType typeApplyMethodProc;
    public static ClassType typeApplyMethodContainer;
    public static ClassType typeCallStack;
    public static Method popCallStackMethod;
    public static ClassType typeValues;
    public static Field noArgsField;
    public static Field valueCallStackField;
    public static Field pcCallStackField;
    public static ClassType typeCpsProcedure;
    public static ClassType typeCallFrame;
    public static Field numArgsCallFrameField;
    public static Field argsCallStackField;
    public static Field procCallStackField;
    public static Field callerCallFrameField;
    public static Field saved_pcCallFrameField;
    private static Type[] applyCpsArgs;
    public static Method applyCpsMethod;
    public static ClassType[] typeProcedureArray;
    Hashtable literalTable;
    int literalsCount;
    Initializer initChain;
    Initializer clinitChain;
    Literal literalsChain;
    public static boolean generateMainDefault;
    public boolean generateMain = generateMainDefault;
    LitTable litTable;
    public static boolean generateAppletDefault;
    public boolean generateApplet = generateAppletDefault;
    public String classPrefix;
    String source_filename;
    int localFieldIndex;
    Hashtable bindingFields = new Hashtable(100);
    String filename;
    int position;

    static {
        usingTailCalls = false;
        moduleStatic = 0;
        typeObject = Type.pointer_type;
        scmBooleanType = ClassType.make("java.lang.Boolean");
        javaStringType = typeString = ClassType.make("java.lang.String");
        scmSymbolType = typeString;
        scmKeywordType = ClassType.make("gnu.expr.Keyword");
        scmSequenceType = ClassType.make("gnu.kawa.util.Sequence");
        javaIntegerType = ClassType.make("java.lang.Integer");
        scmListType = ClassType.make("gnu.kawa.util.LList");
        scmPairType = typePair = ClassType.make("gnu.kawa.util.Pair");
        scmUndefinedType = ClassType.make("gnu.expr.Undefined");
        objArrayType = ArrayType.make(typeObject);
        symbolArrayType = ArrayType.make(scmSymbolType);
        scmNamedType = ClassType.make("gnu.mapping.Named");
        typeRunnable = ClassType.make("java.lang.Runnable");
        typeProcedure = ClassType.make("gnu.mapping.Procedure");
        typeInterpreter = ClassType.make("gnu.expr.Interpreter");
        typeMacro = ClassType.make("kawa.lang.Macro");
        typeEnvironment = ClassType.make("gnu.mapping.Environment");
        typeLocation = ClassType.make("gnu.mapping.Location");
        typeBinding = ClassType.make("gnu.mapping.Binding", typeLocation);
        typeBinding2 = ClassType.make("gnu.mapping.Binding2", typeBinding);
        functionValueBinding2Field = typeBinding2.addField("functionValue", Type.pointer_type, 1);
        getLocationMethod = typeLocation.addMethod("get", Type.typeArray0, Type.pointer_type, 1);
        getProcedureBindingMethod = typeBinding.addMethod("getProcedure", Type.typeArray0, typeProcedure, 1);
        trueConstant = scmBooleanType.addField("TRUE", scmBooleanType, 9);
        falseConstant = scmBooleanType.addField("FALSE", scmBooleanType, 9);
        voidConstant = typeInterpreter.addField("voidObject", typeObject, 9);
        undefinedConstant = typeInterpreter.addField("undefinedObject", scmUndefinedType, 9);
        emptyConstant = scmListType.addField("Empty", scmListType, 9);
        setNameMethod = typeProcedure.getDeclaredMethod("setName", 1);
        int1Args = new Type[]{Type.int_type};
        string1Arg = new Type[]{javaStringType};
        sym1Arg = string1Arg;
        getBindingEnvironmentMethod = typeEnvironment.addMethod("getBinding", string1Arg, typeBinding, 1);
        getBinding2Method = typeBinding2.getDeclaredMethod("getBinding2", 2);
        Type[] typeArray = new Type[]{objArrayType, Type.int_type};
        makeListMethod = scmListType.addMethod("makeList", typeArray, scmListType, 9);
        initIntegerMethod = javaIntegerType.addMethod("<init>", int1Args, Type.void_type, 1);
        lookupGlobalMethod = typeEnvironment.addMethod("lookup_global", sym1Arg, typeObject, 9);
        Type[] typeArray2 = new Type[]{scmSymbolType, typeObject};
        defineGlobalMethod = typeEnvironment.addMethod("define_global", typeArray2, Type.void_type, 9);
        defineFunctionMethod = typeEnvironment.addMethod("defineFunction", typeArray2, Type.void_type, 9);
        putGlobalMethod = typeEnvironment.addMethod("put_global", typeArray2, Type.void_type, 9);
        getCurrentEnvironmentMethod = typeEnvironment.addMethod("getCurrent", Type.typeArray0, typeEnvironment, 9);
        apply0args = Type.typeArray0;
        apply1args = new Type[]{typeObject};
        apply2args = new Type[]{typeObject, typeObject};
        applyNargs = new Type[]{objArrayType};
        apply0method = typeProcedure.addMethod("apply0", apply0args, typeObject, 17);
        apply1method = typeProcedure.addMethod("apply1", apply1args, typeObject, 1);
        apply2method = typeProcedure.addMethod("apply2", apply2args, typeObject, 1);
        typeArray = new Type[]{typeObject, typeObject, typeObject};
        apply3method = typeProcedure.addMethod("apply3", typeArray, typeObject, 1);
        typeArray2 = new Type[]{typeObject, typeObject, typeObject, typeObject};
        apply4method = typeProcedure.addMethod("apply4", typeArray2, typeObject, 1);
        applyNmethod = typeProcedure.addMethod("applyN", applyNargs, typeObject, 1);
        Type[] typeArray3 = new Type[]{typeProcedure, Type.int_type};
        checkArgCountMethod = typeProcedure.addMethod("checkArgCount", typeArray3, Type.void_type, 9);
        applymethods = new Method[]{apply0method, apply1method, apply2method, apply3method, apply4method, applyNmethod};
        typeProcedure0 = ClassType.make("gnu.mapping.Procedure0", typeProcedure);
        typeProcedure1 = ClassType.make("gnu.mapping.Procedure1", typeProcedure);
        typeProcedure2 = ClassType.make("gnu.mapping.Procedure2", typeProcedure);
        typeProcedure3 = ClassType.make("gnu.mapping.Procedure3", typeProcedure);
        typeProcedure4 = ClassType.make("gnu.mapping.Procedure4", typeProcedure);
        typeProcedureN = ClassType.make("gnu.mapping.ProcedureN", typeProcedure);
        typeModuleBody = ClassType.make("gnu.expr.ModuleBody", typeProcedure0);
        typeApplet = ClassType.make("java.applet.Applet");
        typeModuleMethod = ClassType.make("gnu.expr.ModuleMethod", typeProcedureN);
        typeApplyMethodProc = ClassType.make("gnu.mapping.ApplyMethodProc", typeProcedureN);
        typeApplyMethodContainer = ClassType.make("gnu.mapping.ApplyMethodContainer");
        typeCallStack = ClassType.make("gnu.mapping.CallStack");
        popCallStackMethod = typeCallStack.addMethod("pop", apply0args, Type.void_type, 1);
        typeValues = ClassType.make("gnu.mapping.Values");
        noArgsField = typeValues.addField("noArgs", objArrayType, 9);
        valueCallStackField = typeCallStack.addField("value", Type.pointer_type, 1);
        pcCallStackField = typeCallStack.addField("pc", Type.int_type, 4);
        typeCpsProcedure = ClassType.make("gnu.mapping.CpsProcedure");
        typeCallFrame = ClassType.make("gnu.mapping.CallFrame");
        numArgsCallFrameField = typeCallFrame.addField("numArgs", Type.int_type, 4);
        argsCallStackField = typeCallStack.addField("args", objArrayType, 4);
        procCallStackField = typeCallStack.addField("proc", typeProcedure, 4);
        callerCallFrameField = typeCallFrame.addField("caller", typeCallFrame, 4);
        saved_pcCallFrameField = typeCallFrame.addField("saved_pc", Type.int_type, 4);
        applyCpsArgs = new Type[]{typeCallStack};
        applyCpsMethod = typeProcedure.addMethod("apply", applyCpsArgs, Type.void_type, 1);
        typeProcedureArray = new ClassType[]{typeProcedure0, typeProcedure1, typeProcedure2, typeProcedure3, typeProcedure4};
        generateMainDefault = false;
        generateAppletDefault = false;
    }

    public Compilation(LambdaExp lambdaExp, String string, String string2, boolean bl) {
        this.source_filename = lambdaExp.filename;
        this.classPrefix = string2;
        this.immediate = bl;
        ChainLambdas.chainLambdas(lambdaExp, this);
        PushApply.pushApply(lambdaExp);
        FindTailCalls.findTailCalls(lambdaExp);
        lambdaExp.setCanRead(true);
        if (!usingCPStyle) {
            FindCapturedVars.findCapturedVars(lambdaExp);
        }
        this.mainClass = this.allocClass(lambdaExp, string);
        this.literalTable = new Hashtable(100);
        this.addClass(lambdaExp);
    }

    public void addClass(ClassType classType) {
        if (this.source_filename != null) {
            classType.setSourceFile(this.source_filename);
        }
        if (this.classes == null) {
            this.classes = new ClassType[20];
        } else if (this.numClasses >= this.classes.length) {
            ClassType[] classTypeArray = new ClassType[2 * this.classes.length];
            System.arraycopy(this.classes, 0, classTypeArray, 0, this.numClasses);
            this.classes = classTypeArray;
        }
        this.classes[this.numClasses++] = classType;
        classType.access_flags = 1;
    }

    public final ClassType addClass(LambdaExp lambdaExp) {
        Object object2;
        Type[] typeArray;
        int n;
        Object object3;
        Method method;
        Type[] typeArray2;
        char c;
        ClassType classType = lambdaExp.type;
        if (classType == typeProcedure) {
            classType = this.allocClass(lambdaExp);
        }
        this.curClass = classType;
        String string = lambdaExp.getFile();
        lambdaExp.type = classType;
        if (string != null) {
            classType.setSourceFile(string);
        }
        LambdaExp lambdaExp2 = this.curLambda;
        this.curLambda = lambdaExp;
        if (lambdaExp.isHandlingTailCalls()) {
            boolean bl = true;
            c = '?';
            typeArray2 = new Type[]{typeCallStack};
        } else if (lambdaExp.min_args != lambdaExp.max_args || lambdaExp.min_args > 4 || fewerClasses && this.curClass == this.mainClass) {
            boolean bl = true;
            c = 'N';
            typeArray2 = new Type[]{new ArrayType(typeObject)};
        } else {
            int n2 = lambdaExp.min_args;
            c = Character.forDigit(n2, 10);
            typeArray2 = new Type[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                typeArray2[n3] = typeObject;
            }
        }
        if (c == 'N' || c == '?') {
            this.method = this.curClass.addMethod("numArgs", apply0args, Type.int_type, 1);
            this.method.init_param_slots();
            CodeAttr codeAttr = this.getCode();
            codeAttr.emitPushInt(lambdaExp.min_args | lambdaExp.max_args << 12);
            codeAttr.emitReturn();
        }
        Expression expression = lambdaExp.body;
        Variable variable = lambdaExp.heapFrame;
        boolean bl = false;
        Label label = null;
        Label label2 = null;
        if (lambdaExp.isModuleBody()) {
            if (((ModuleExp)lambdaExp).isStatic()) {
                bl = true;
                this.generateConstructor(this.curClass, lambdaExp);
                this.instanceField = this.curClass.addField("$instance", this.curClass, 24);
                method = this.startClassInit();
                CodeAttr codeAttr = this.getCode();
                codeAttr.emitNew(this.curClass);
                codeAttr.emitDup(this.curClass);
                codeAttr.emitInvokeSpecial(this.curClass.constructor);
                codeAttr.emitPutStatic(this.instanceField);
                label = new Label(codeAttr);
                label2 = new Label(codeAttr);
                codeAttr.emitGoto(label);
                label2.define(codeAttr);
            } else {
                object3 = Type.pointer_type;
                if (this.curClass.getSuperclass() != typeModuleBody) {
                    this.curClass.addInterface(typeRunnable);
                    object3 = Type.void_type;
                }
                method = this.curClass.addMethod("run", typeArray2, (Type)object3, 17);
            }
        } else if (lambdaExp.isHandlingTailCalls()) {
            method = this.curClass.addMethod("apply", typeArray2, Type.void_type, 17);
        } else {
            object3 = "apply" + c;
            method = this.curClass.addMethod((String)object3, typeArray2, typeObject, 17);
        }
        this.method = method;
        this.method.initCode();
        CodeAttr codeAttr = this.getCode();
        this.thisDecl = this.method.getStaticFlag() ? null : lambdaExp.declareThis(classType);
        object3 = this.thisDecl;
        if (lambdaExp instanceof ModuleExp) {
            lambdaExp.heapFrame = lambdaExp.thisVariable;
        }
        if (!fewerClasses || this.curClass != this.mainClass) {
            lambdaExp.allocChildClasses(this);
        }
        if (lambdaExp.isHandlingTailCalls()) {
            this.callStackContext = new Variable("stack", typeCallStack);
            Scope scope = lambdaExp.scope;
            scope.addVariableAfter(this.thisDecl, this.callStackContext);
            this.callStackContext.setParameter(true);
            this.callStackContext.setArtificial(true);
        }
        if ((n = lambdaExp.getLine()) > 0) {
            codeAttr.putLineNumber(n);
        }
        lambdaExp.allocParameters(this);
        lambdaExp.enterFunction(this);
        try {
            expression.compileWithPosition(this, lambdaExp.isModuleBody() ? Target.pushObject : Target.returnObject);
        }
        catch (Exception exception) {
            this.error('f', "internal error while compiling - caught: " + exception);
            exception.printStackTrace(System.err);
            System.exit(-1);
        }
        if (bl) {
            codeAttr.emitReturn();
        } else {
            lambdaExp.compileEnd(this);
        }
        if (fewerClasses) {
            this.method.popScope();
        }
        lambdaExp.heapFrame = variable;
        lambdaExp.compileChildMethods(this);
        if (Compilation.usingCPStyle() || fewerClasses && this.curClass == this.mainClass) {
            codeAttr = this.getCode();
            this.fswitch.finish(codeAttr);
        }
        if (lambdaExp.isModuleBody()) {
            this.generateApplyMethods();
        }
        if (!bl) {
            this.generateConstructor(this.curClass, lambdaExp);
        }
        if (this.curClass == this.mainClass && !this.immediate && (bl || this.clinitChain != null || this.literalsChain != null)) {
            typeArray = this.method;
            if (bl) {
                label.define(codeAttr);
            } else {
                this.startClassInit();
            }
            codeAttr = this.getCode();
            if (this.clinitChain != null) {
                object2 = new Label(codeAttr);
                Label label3 = new Label(codeAttr);
                Label label4 = new Label(codeAttr);
                codeAttr.emitGoto(label3);
                ((Label)object2).define(codeAttr);
                this.dumpInitializers(this.clinitChain);
                codeAttr.emitGoto(label4);
                label3.define(codeAttr);
                Literal.emit(this);
                codeAttr.emitGoto((Label)object2);
                label4.define(codeAttr);
            } else {
                Literal.emit(this);
            }
            if (bl) {
                this.initBindingFields();
                codeAttr.emitGoto(label2);
            } else {
                codeAttr.emitReturn();
            }
            this.method = typeArray;
        }
        this.curLambda = lambdaExp2;
        if (this.generateMain && lambdaExp.isModuleBody() && this.curClass == this.mainClass) {
            typeArray = new Type[]{new ArrayType(javaStringType)};
            this.method = this.curClass.addMethod("main", 9, typeArray, Type.void_type);
            this.method.init_param_slots();
            codeAttr = this.getCode();
            codeAttr.emitNew(this.curClass);
            codeAttr.emitDup(this.curClass);
            codeAttr.emitInvokeSpecial(this.curClass.constructor);
            codeAttr.emitLoad(codeAttr.getArg(0));
            object2 = typeModuleBody.addMethod("runAsMain", 1, typeArray, Type.void_type);
            codeAttr.emitInvokeVirtual((Method)object2);
            codeAttr.emitReturn();
        }
        return classType;
    }

    ClassType allocClass(LambdaExp lambdaExp) {
        String string = lambdaExp.getJavaName();
        string = this.generateClassName(string);
        return this.allocClass(lambdaExp, string);
    }

    ClassType allocClass(LambdaExp lambdaExp, String string) {
        ClassType classType;
        if (lambdaExp instanceof ObjectExp) {
            classType = lambdaExp.getCompiledClassType(this);
        } else {
            ClassType classType2;
            classType = new ClassType(string);
            if (lambdaExp.isModuleBody()) {
                ModuleExp moduleExp = (ModuleExp)lambdaExp;
                classType2 = this.getModuleSuperType(moduleExp);
                ClassType[] classTypeArray = moduleExp.getInterfaces();
                if (classTypeArray != null) {
                    classType.setInterfaces(classTypeArray);
                }
            } else {
                classType2 = usingCPStyle ? typeCallFrame : (lambdaExp.isHandlingTailCalls() ? typeCpsProcedure : (lambdaExp.min_args != lambdaExp.max_args || lambdaExp.min_args > 4 ? typeProcedureN : typeProcedureArray[lambdaExp.min_args]));
            }
            classType.setSuper(classType2);
            lambdaExp.type = classType;
            this.addClass(classType);
        }
        return classType;
    }

    public Field allocLocalField(Type type, String string) {
        if (string == null) {
            string = "tmp_" + ++this.localFieldIndex;
        }
        Field field = this.curClass.addField(string, type, 0);
        return field;
    }

    public void compileConstant(Object object2) {
        CodeAttr codeAttr = this.getCode();
        if (object2 == null) {
            codeAttr.emitPushNull();
        } else if (object2 instanceof String && !this.immediate) {
            codeAttr.emitPushString((String)object2);
        } else {
            Literal literal = this.findLiteral(object2);
            if (literal.field == null) {
                literal.assign(this);
            }
            codeAttr.emitGetStatic(literal.field);
        }
    }

    public void compileConstant(Object object2, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (target instanceof ConditionalTarget) {
            ConditionalTarget conditionalTarget = (ConditionalTarget)target;
            this.getCode().emitGoto(this.getInterpreter().isTrue(object2) ? conditionalTarget.ifTrue : conditionalTarget.ifFalse);
            return;
        }
        if (target instanceof StackTarget) {
            Type type = ((StackTarget)target).getType();
            if (type instanceof PrimType) {
                try {
                    int n;
                    String string = type.getSignature();
                    CodeAttr codeAttr = this.getCode();
                    int n2 = n = string == null || string.length() != 1 ? 32 : (int)string.charAt(0);
                    if (object2 instanceof Number) {
                        Number number = (Number)object2;
                        switch (n) {
                            case 66: 
                            case 73: 
                            case 83: {
                                codeAttr.emitPushInt(number.intValue());
                                return;
                            }
                            case 74: {
                                codeAttr.emitPushLong(number.longValue());
                                return;
                            }
                            case 70: {
                                codeAttr.emitPushFloat(number.floatValue());
                                return;
                            }
                            case 68: {
                                codeAttr.emitPushDouble(number.doubleValue());
                                return;
                            }
                        }
                    }
                    if (n == 67) {
                        codeAttr.emitPushInt(((PrimType)type).charValue(object2));
                        return;
                    }
                    if (n == 90) {
                        boolean bl = ((PrimType)type).booleanValue(object2);
                        codeAttr.emitPushInt(bl ? 1 : 0);
                        return;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            try {
                object2 = type.coerceFromObject(object2);
            }
            catch (Exception exception) {
                this.error('w', "cannot convert literal (of type " + object2.getClass().getName() + ") to " + type.getName());
            }
        }
        this.compileConstant(object2);
        target.compileFromStack(this, object2 == null ? target.getType() : Type.make(object2.getClass()));
    }

    public static char demangle2(char c, char c2) {
        switch (c) {
            case 'E': {
                switch (c2) {
                    case 'x': {
                        return '!';
                    }
                    default: {
                        return '\uffff';
                    }
                }
            }
            case 'M': {
                switch (c2) {
                    case 'c': {
                        return '%';
                    }
                    case 'n': {
                        return '-';
                    }
                    default: {
                        return '\uffff';
                    }
                }
            }
            case 'P': {
                switch (c2) {
                    case 'l': {
                        return '+';
                    }
                    default: {
                        return '\uffff';
                    }
                }
            }
            case 'S': {
                switch (c2) {
                    case 'l': {
                        return '/';
                    }
                    case 't': {
                        return '*';
                    }
                }
            }
        }
        return '\uffff';
    }

    private void dumpInitializers(Initializer initializer) {
        Initializer initializer2 = initializer;
        while (initializer2 != null) {
            initializer2.emit(this);
            initializer2 = initializer2.next;
        }
    }

    public void error(char c, String string) {
        this.error(c, this.filename, this.position >> 12, this.position & 0xFFF, string);
    }

    public void error(char c, String string, int n, int n2, String string2) {
        this.error(new SourceError(c, string, n, n2, string2));
    }

    public void error(SourceError sourceError) {
        System.err.println(sourceError);
    }

    public Literal findLiteral(Object object2) {
        if (object2 == null) {
            return Literal.nullLiteral;
        }
        Literal literal = (Literal)this.literalTable.get(object2);
        if (literal == null) {
            boolean bl;
            literal = object2 instanceof Boolean ? new Literal(object2, (bl = ((Boolean)object2).booleanValue()) ? trueConstant : falseConstant, this) : (object2 == Values.empty ? new Literal(object2, voidConstant, this) : (object2 == LList.Empty ? new Literal(object2, emptyConstant, this) : (object2 instanceof Undefined ? new Literal(object2, undefinedConstant, this) : (this.immediate ? new Literal(object2, this) : new Literal(object2, Type.make(object2.getClass()), this)))));
        }
        return literal;
    }

    public ClassType findNamedClass(String string) {
        int n = 0;
        while (n < this.numClasses) {
            if (string.equals(this.classes[n].getName())) {
                return this.classes[n];
            }
            ++n;
        }
        return null;
    }

    public void freeLocalField(Field field) {
    }

    public void generateApplyMethods() {
        ClassType classType;
        int n = this.applyMethods.size();
        if (n == 0) {
            return;
        }
        boolean bl = this.curClass.getSuperclass().isSubtype(typeProcedure) ^ true;
        ClassType classType2 = classType = bl ? typeApplyMethodProc : typeModuleMethod;
        if (bl) {
            this.curClass.addInterface(typeApplyMethodContainer);
        }
        Method method = this.method;
        CodeAttr codeAttr = null;
        int n2 = 0;
        while (n2 < 6) {
            boolean bl2 = false;
            SwitchState switchState = null;
            String string = null;
            Type[] typeArray = null;
            int n3 = n;
            while (--n3 >= 0) {
                Type type;
                int n4;
                int n5;
                LambdaExp lambdaExp = (LambdaExp)this.applyMethods.elementAt(n3);
                Method[] methodArray = lambdaExp.primMethods;
                int n6 = methodArray.length;
                boolean bl3 = lambdaExp.max_args < 0 || lambdaExp.max_args >= lambdaExp.min_args + n6;
                boolean bl4 = false;
                if (n2 < 5) {
                    n5 = n2 - lambdaExp.min_args;
                    if (n5 < 0 || n5 >= n6 || n5 == n6 - 1 && bl3) {
                        bl4 = true;
                    }
                    n6 = 1;
                    bl3 = false;
                } else {
                    n5 = 5 - lambdaExp.min_args;
                    if (n5 > 0 && n6 <= n5 && !bl3) {
                        bl4 = true;
                    }
                    n5 = n6 - 1;
                }
                if (bl4 && !bl) continue;
                if (!bl2) {
                    if (n2 < 5) {
                        string = "apply" + n2;
                        typeArray = new Type[n2 + 1];
                        int n7 = n2;
                        while (n7 > 0) {
                            typeArray[n7] = typeObject;
                            --n7;
                        }
                    } else {
                        string = "applyN";
                        typeArray = new Type[2];
                        typeArray[1] = objArrayType;
                    }
                    typeArray[0] = classType;
                    this.method = this.curClass.addMethod(string, typeArray, Type.pointer_type, 1);
                    this.method.init_param_slots();
                    codeAttr = this.getCode();
                    codeAttr.emitLoad(codeAttr.getArg(1));
                    codeAttr.emitGetField(classType.getDeclaredField("selector"));
                    switchState = new SwitchState(codeAttr);
                    bl2 = true;
                }
                if (bl4 && bl) continue;
                switchState.addCase(lambdaExp.getSelectorValue(this), codeAttr);
                Method method2 = methodArray[n5];
                Type[] typeArray2 = method2.getParameterTypes();
                int n8 = typeArray2.length;
                int n9 = bl3 ? n8 - 1 : n8;
                Variable variable = null;
                int n10 = 0;
                if (n2 > 4 && n6 > 1) {
                    variable = codeAttr.addLocal(Type.int_type);
                    codeAttr.emitLoad(codeAttr.getArg(2));
                    codeAttr.emitArrayLength();
                    if (lambdaExp.min_args != 0) {
                        codeAttr.emitPushInt(lambdaExp.min_args);
                        codeAttr.emitSub(Type.int_type);
                    }
                    codeAttr.emitStore(variable);
                }
                int n11 = n4 = method2.getStaticFlag() ? 0 : 1;
                if (n4 > 0) {
                    codeAttr.emitPushThis();
                }
                int n12 = 0;
                while (n12 < n9) {
                    if (variable != null && n12 >= lambdaExp.min_args) {
                        codeAttr.emitLoad(variable);
                        codeAttr.emitIfIntLEqZero();
                        codeAttr.emitInvoke(methodArray[n12 - lambdaExp.min_args]);
                        codeAttr.emitElse();
                        ++n10;
                        codeAttr.emitInc(variable, (short)-1);
                    }
                    if (n2 > 4) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(n12);
                        codeAttr.emitArrayLoad(Type.pointer_type);
                    } else {
                        codeAttr.emitLoad(codeAttr.getArg(n12 + 2));
                    }
                    type = typeArray2[n12];
                    if (type != Type.pointer_type) {
                        CheckedTarget.emitCheckedCoerce(this, lambdaExp, n12, type);
                    }
                    ++n12;
                }
                if (bl3) {
                    type = typeArray2[n9];
                    if (type instanceof ArrayType) {
                        Type type2 = ((ArrayType)type).getComponentType();
                        boolean bl5 = "java.lang.Object".equals(type2.getName()) ^ true;
                        if (n9 == 0 && !bl5) {
                            codeAttr.emitLoad(codeAttr.getArg(2));
                        } else {
                            codeAttr.pushScope();
                            if (variable == null) {
                                variable = codeAttr.addLocal(Type.int_type);
                                codeAttr.emitLoad(codeAttr.getArg(2));
                                codeAttr.emitArrayLength();
                                if (n9 != 0) {
                                    codeAttr.emitPushInt(n9);
                                    codeAttr.emitSub(Type.int_type);
                                }
                                codeAttr.emitStore(variable);
                            }
                            codeAttr.emitLoad(variable);
                            codeAttr.emitNewArray(type2);
                            Label label = new Label(codeAttr);
                            codeAttr.emitGoto(label);
                            Label label2 = new Label(codeAttr);
                            label2.define(codeAttr);
                            codeAttr.emitDup(1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitLoad(codeAttr.getArg(2));
                            codeAttr.emitLoad(variable);
                            if (n9 != 0) {
                                codeAttr.emitPushInt(n9);
                                codeAttr.emitAdd(Type.int_type);
                            }
                            codeAttr.emitArrayLoad(Type.pointer_type);
                            if (bl5) {
                                CheckedTarget.emitCheckedCoerce(this, lambdaExp, lambdaExp.getName(), -1, type2);
                            }
                            codeAttr.emitArrayStore(type2);
                            label.define(codeAttr);
                            codeAttr.emitInc(variable, (short)-1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitGotoIfIntGeZero(label2);
                            codeAttr.popScope();
                        }
                    } else if ("gnu.kawa.util.LList".equals(type.getName())) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(n9);
                        codeAttr.emitInvokeStatic(makeListMethod);
                    } else {
                        throw new RuntimeException("unsupported #!rest type");
                    }
                }
                codeAttr.emitInvoke(method2);
                while (--n10 >= 0) {
                    codeAttr.emitFi();
                }
                Target.pushObject.compileFromStack(this, method2.getReturnType());
                codeAttr.emitReturn();
            }
            if (bl2) {
                switchState.addDefault(codeAttr);
                int n13 = n2 > 4 ? 2 : n2 + 1;
                ++n13;
                int n14 = bl ? 1 : 0;
                while (n14 < n13) {
                    codeAttr.emitLoad(codeAttr.getArg(n14));
                    ++n14;
                }
                if (bl) {
                    string = String.valueOf(string) + "Default";
                    Method method3 = typeApplyMethodProc.getDeclaredMethod(string, typeArray);
                    codeAttr.emitInvokeStatic(method3);
                } else {
                    codeAttr.emitInvokeSpecial(this.curClass.getSuperclass().getDeclaredMethod(string, typeArray));
                }
                codeAttr.emitReturn();
                switchState.finish(codeAttr);
            }
            ++n2;
        }
        this.method = method;
    }

    public String generateClassName(String string) {
        string = Compilation.mangleName(string);
        if (this.mainClass != null) {
            string = String.valueOf(this.mainClass.getName()) + '$' + string;
        } else if (this.classPrefix != null) {
            string = String.valueOf(this.classPrefix) + string;
        }
        if (this.findNamedClass(string) == null) {
            return string;
        }
        int n = 0;
        String string2;
        while (this.findNamedClass(string2 = String.valueOf(string) + n) != null) {
            ++n;
        }
        return string2;
    }

    public final Method generateConstructor(ClassType classType, LambdaExp lambdaExp) {
        Method method;
        Method method2 = this.method;
        ClassType classType2 = this.curClass;
        this.curClass = classType;
        classType.constructor = method = classType.addMethod("<init>", 1, apply0args, Type.void_type);
        Method method3 = classType.getSuperclass().addMethod("<init>", 1, apply0args, Type.void_type);
        this.method = method;
        method.init_param_slots();
        CodeAttr codeAttr = this.getCode();
        codeAttr.emitPushThis();
        codeAttr.emitInvokeSpecial(method3);
        if (this.curClass == this.mainClass) {
            Initializer initializer;
            while ((initializer = this.initChain) != null) {
                this.initChain = initializer.next;
                initializer.emit(this);
            }
        }
        if (lambdaExp != null && lambdaExp.name != null && !this.immediate) {
            method.compile_push_this();
            this.compileConstant(lambdaExp.name);
            codeAttr.emitInvokeVirtual(setNameMethod);
        }
        if (this.curClass == this.mainClass) {
            this.initBindingFields();
        }
        codeAttr.emitReturn();
        this.method = method2;
        this.curClass = classType2;
        return method;
    }

    public Field getBindingField(String string) {
        Object v = this.bindingFields.get(string);
        if (v != null) {
            return (Field)v;
        }
        String string2 = "id" + this.bindingFields.size() + "$" + Compilation.mangleName(string);
        ClassType classType = this.getInterpreter().hasSeparateFunctionNamespace() ? typeBinding2 : typeBinding;
        Field field = this.mainClass.addField(string2, classType, 8);
        this.bindingFields.put(string, field);
        return field;
    }

    public final CodeAttr getCode() {
        return this.method.getCode();
    }

    public Interpreter getInterpreter() {
        return Interpreter.defaultInterpreter;
    }

    public static final ClassType getMethodProcType(ClassType classType) {
        return classType.getSuperclass().isSubtype(typeProcedure) ? typeModuleMethod : typeApplyMethodProc;
    }

    public final ClassType getModuleSuperType(ModuleExp moduleExp) {
        ClassType classType = moduleExp.getSuperType();
        return classType != null ? classType : (this.generateApplet ? typeApplet : typeModuleBody);
    }

    void initBindingFields() {
        CodeAttr codeAttr = this.getCode();
        int n = this.bindingFields.size();
        if (n > 0) {
            codeAttr.emitInvokeStatic(getCurrentEnvironmentMethod);
            Enumeration enumeration = this.bindingFields.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Field field = (Field)this.bindingFields.get(string);
                if (--n > 0) {
                    codeAttr.emitDup(1);
                }
                codeAttr.emitPushString(string);
                if (this.getInterpreter().hasSeparateFunctionNamespace()) {
                    codeAttr.emitInvokeStatic(getBinding2Method);
                } else {
                    codeAttr.emitInvokeVirtual(getBindingEnvironmentMethod);
                }
                codeAttr.emitPutStatic(field);
            }
        }
    }

    public static String mangleName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl) {
                c = Character.toTitleCase(c);
                bl = false;
            }
            if (Character.isDigit(c)) {
                if (n2 == 0) {
                    stringBuffer.append("$N");
                }
                stringBuffer.append(c);
            } else if (Character.isLetter(c) || c == '_' || c == '$') {
                stringBuffer.append(c);
            } else {
                switch (c) {
                    case '+': {
                        stringBuffer.append("$Pl");
                        break;
                    }
                    case '-': {
                        char c2;
                        char c3 = c2 = n2 + 1 < n ? string.charAt(n2 + 1) : (char)'\u0000';
                        if (c2 == '>') {
                            stringBuffer.append("$To$");
                            ++n2;
                            break;
                        }
                        if (Character.isLowerCase(c2)) break;
                        stringBuffer.append("$Mn");
                        break;
                    }
                    case '*': {
                        stringBuffer.append("$St");
                        break;
                    }
                    case '/': {
                        stringBuffer.append("$Sl");
                        break;
                    }
                    case '=': {
                        stringBuffer.append("$Eq");
                        break;
                    }
                    case '<': {
                        stringBuffer.append("$Ls");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("$Gr");
                        break;
                    }
                    case '@': {
                        stringBuffer.append("$At");
                        break;
                    }
                    case '~': {
                        stringBuffer.append("$Tl");
                        break;
                    }
                    case '%': {
                        stringBuffer.append("$Pc");
                        break;
                    }
                    case '.': {
                        stringBuffer.append("$Dt");
                        break;
                    }
                    case ',': {
                        stringBuffer.append("$Cm");
                        break;
                    }
                    case '(': {
                        stringBuffer.append("$LP");
                        break;
                    }
                    case ')': {
                        stringBuffer.append("$RP");
                        break;
                    }
                    case '[': {
                        stringBuffer.append("$LB");
                        break;
                    }
                    case ']': {
                        stringBuffer.append("$RB");
                        break;
                    }
                    case '{': {
                        stringBuffer.append("$LC");
                        break;
                    }
                    case '}': {
                        stringBuffer.append("$RC");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("$Sq");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("$Dq");
                        break;
                    }
                    case '&': {
                        stringBuffer.append("$Am");
                        break;
                    }
                    case '#': {
                        stringBuffer.append("$Nm");
                        break;
                    }
                    case '?': {
                        char c4;
                        char c5 = c4 = stringBuffer.length() > 0 ? stringBuffer.charAt(0) : (char)'\u0000';
                        if (n2 + 1 == n && Character.isLowerCase(c4)) {
                            stringBuffer.setCharAt(0, Character.toTitleCase(c4));
                            stringBuffer.insert(0, "is");
                            break;
                        }
                        stringBuffer.append("$Qu");
                        break;
                    }
                    case '!': {
                        stringBuffer.append("$Ex");
                        break;
                    }
                    case ':': {
                        stringBuffer.append("$Cl");
                        break;
                    }
                    case ';': {
                        stringBuffer.append("$SC");
                        break;
                    }
                    case '^': {
                        stringBuffer.append("$Up");
                        break;
                    }
                    case '|': {
                        stringBuffer.append("$VB");
                        break;
                    }
                    default: {
                        stringBuffer.append('$');
                        stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c & 0xF, 16));
                    }
                }
                bl = true;
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        return string2.equals(string) ? string : string2;
    }

    private Method startClassInit() {
        ClassType classType;
        Method method;
        this.method = this.curClass.addMethod("<clinit>", apply0args, Type.void_type, 9);
        this.method.init_param_slots();
        CodeAttr codeAttr = this.getCode();
        if ((this.generateMain || this.generateApplet) && (method = (classType = (ClassType)Type.make(this.getInterpreter().getClass())).getDeclaredMethod("registerEnvironment", 0)) != null) {
            codeAttr.emitInvokeStatic(method);
        }
        return this.method;
    }

    public static boolean usingCPStyle() {
        return usingCPStyle;
    }

    public static boolean usingTailCalls() {
        return usingTailCalls;
    }
}

