/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.mapping.InPort;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;

public abstract class LispReader
extends Lexer {
    public LispReader(LineBufferedReader lineBufferedReader) {
        super(lineBufferedReader);
    }

    public LispReader(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages) {
        super(lineBufferedReader, sourceMessages);
    }

    protected boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || c == ')' || c == '(' || c == '\"' || c == ';';
    }

    protected abstract Object makeNil();

    protected abstract Object makePair(Object var1, int var2, int var3);

    protected int readEscape() throws IOException, SyntaxException {
        int n = this.read();
        if (n < 0) {
            this.eofError("unexpected EOF in character literal");
            return -1;
        }
        return this.readEscape(n);
    }

    protected final int readEscape(int n) throws IOException, SyntaxException {
        block0 : switch ((char)n) {
            case 'a': {
                n = 7;
                break;
            }
            case 'b': {
                n = 8;
                break;
            }
            case 't': {
                n = 9;
                break;
            }
            case 'n': {
                n = 10;
                break;
            }
            case 'v': {
                n = 11;
                break;
            }
            case 'f': {
                n = 12;
                break;
            }
            case 'r': {
                n = 13;
                break;
            }
            case 'e': {
                n = 27;
                break;
            }
            case '\"': {
                n = 34;
                break;
            }
            case '\\': {
                n = 92;
                break;
            }
            case ' ': {
                do {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected EOF in character literal");
                        return -1;
                    }
                    if (n == 10) {
                        return -2;
                    }
                    if (n != 13) continue;
                    if (this.peek() == 10) {
                        this.skip();
                    }
                    return -2;
                } while (n == 32 || n == 9);
                this.unread(n);
            }
            case '\r': {
                if (this.peek() == 10) {
                    this.skip();
                }
                return -2;
            }
            case '\n': {
                return -2;
            }
            case 'M': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                return n | 0x80;
            }
            case 'C': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
            }
            case '^': {
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                if (n == 63) {
                    return 127;
                }
                return n & 0x9F;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                n -= 48;
                int n2 = 0;
                while (++n2 < 3) {
                    int n3 = this.read();
                    int n4 = Character.digit((char)n3, 8);
                    if (n4 >= 0) {
                        n = (n << 3) + n4;
                        continue;
                    }
                    if (n3 < 0) break block0;
                    this.unread(n3);
                    break block0;
                }
                break;
            }
            case 'u': {
                n = 0;
                int n5 = 4;
                while (--n5 >= 0) {
                    int n6;
                    int n7 = this.read();
                    if (n7 < 0) {
                        this.eofError("premature EOF in \\u escape");
                    }
                    if ((n6 = Character.digit((char)n7, 16)) < 0) {
                        this.error("non-hex character following \\u");
                    }
                    n = 16 * n + n6;
                }
                break;
            }
            case 'x': {
                int n8;
                int n9;
                n = 0;
                while ((n9 = Character.digit((char)(n8 = this.read()), 16)) >= 0) {
                    n = (n << 4) + n9;
                }
                if (n8 < 0) break;
                this.unread(n8);
                break;
            }
        }
        return n;
    }

    protected Object readList() throws IOException, SyntaxException {
        return this.readList(')');
    }

    protected Object readList(char c) throws IOException, SyntaxException {
        char c2 = ((InPort)this.port).readState;
        ((InPort)this.port).readState = c;
        int n = this.port.getLineNumber();
        int n2 = this.port.getColumnNumber();
        try {
            Object object2 = this.readListBody(c);
            int n3 = this.read();
            if (n3 < 0) {
                this.error('e', this.port.getName(), n + 1, n2 + 1, "unexpected EOF in list starting here");
            }
            Object object3 = object2;
            Object var7_8 = null;
            ((InPort)this.port).readState = c2;
            return object3;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            ((InPort)this.port).readState = c2;
            throw throwable;
        }
    }

    public Object readListBody() throws IOException, SyntaxException {
        return this.readListBody(41);
    }

    public Object readListBody(int n) throws IOException, SyntaxException {
        int n2;
        Object object2 = null;
        Object object3 = this.makeNil();
        while ((n2 = this.skipWhitespaceAndComments()) >= 0) {
            Object object4;
            this.unread(n2);
            if (n2 == n) break;
            int n3 = this.port.getLineNumber();
            int n4 = this.port.getColumnNumber();
            this.skip();
            if (n2 == 46) {
                int n5 = this.peek();
                if (n5 < 0) {
                    this.eofError(". followed by EOF");
                }
                if (this.isDelimiter((char)n5)) {
                    object4 = this.readObject();
                    n2 = this.skipWhitespaceAndComments();
                    if (n2 != n) {
                        this.error(". OBJECT not followed by `" + n + "'");
                    }
                    if (n2 >= 0) {
                        this.unread(n2);
                    }
                    if (object2 == null) {
                        return object4;
                    }
                    this.setCdr(object2, object4);
                    return object3;
                }
            }
            Object object5 = this.readObject(n2);
            object4 = this.makePair(object5, n3, n4);
            if (object2 == null) {
                object3 = object4;
            } else {
                this.setCdr(object2, object4);
            }
            object2 = object4;
        }
        return object3;
    }

    public final void readNestedComment() throws IOException {
        int n = 1;
        do {
            int n2;
            if ((n2 = this.read()) == 124) {
                n2 = this.read();
                if (n2 == 35) {
                    --n;
                }
            } else if (n2 == 35 && (n2 = this.read()) == 124) {
                ++n;
            }
            if (n2 >= 0) continue;
            this.error("unexpected eof in #| comment.");
            return;
        } while (n > 0);
    }

    public Object readObject() throws IOException, SyntaxException {
        char c = ((InPort)this.port).readState;
        ((InPort)this.port).readState = (char)32;
        try {
            Object object2 = this.readObject(this.read());
            Object var4_3 = null;
            ((InPort)this.port).readState = c;
            return object2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InPort)this.port).readState = c;
            throw throwable;
        }
    }

    public abstract Object readObject(int var1) throws IOException, SyntaxException;

    protected abstract void setCdr(Object var1, Object var2);

    protected int skipWhitespaceAndComments() throws IOException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                return n;
            }
            if (n == 59) {
                do {
                    if ((n = this.read()) >= 0) continue;
                    return n;
                } while (n != 10 && n != 13);
                continue;
            }
            if (n == 35 && this.peek() == 124) {
                this.read();
                this.readNestedComment();
                continue;
            }
            if (!Character.isWhitespace((char)n)) break;
        }
        return n;
    }
}

