var env;

function init ()
{
  env = Components.classes["urn:swarm:SwarmEnvironmentImpl"].
      createInstance (Components.interfaces.swarmISwarmEnvironment);

  env.initSwarm_version_bugAddress_argCount_args ("test",
                                                  "0.0",
                                                  "bug-swarm@swarm.org",
                                                  0, []);
}


function Agent ()
{
  var swarm = Components.classes["urn:swarm:objectbase.SwarmImpl"].
                createInstance (Components.interfaces.swarmICreate);

  swarm.create (env.globalZone);
  this.swarm = swarm.QueryInterface (Components.interfaces.swarmISwarm);
}

Agent.prototype.stepAgent =
function ()
{
  dump (env.getCurrentTime () + "\n");
}

Agent.prototype.QueryInterface = 
function (iid)
{
   if (!iid.equals (Components.interfaces.nsISupports)
       && !iid.equals (Components.interfaces.swarmIAgent))
     throw Components.results.NS_ERROR_NO_INTERFACE;

   return this;
}

Agent.prototype.buildActions =
function ()
{
  var sel =
    Components.classes["urn:swarm:SelectorImpl"].
     createInstance (Components.interfaces.swarmISelector);

  sel.create (this, "stepAgent");

  this.schedule = 
    Components.classes["urn:swarm:activity.ScheduleImpl"]. 
      createInstance (Components.interfaces.swarmISchedule);

  this.schedule.create_setRepeatInterval (env.globalZone, 5);

  this.schedule.at_createActionTo_message (0, this, sel);
}

Agent.prototype.activateIn =
function (swarmContext)
{
  this.swarm.QueryInterface (Components.interfaces.swarmIActionType).activateIn (swarmContext);

  this.schedule.QueryInterface (Components.interfaces.swarmIActionType).activateIn (this.swarm);
  return this.swarm.QueryInterface (Components.interfaces.swarmISwarmProcess).getActivity ();
}