/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class dump
extends ClassFileInput {
    ClassTypeWriter writer;

    public dump(InputStream str) throws IOException, ClassFormatError {
        super(str);
        this.ctype = new ClassType();
        this.writer = new ClassTypeWriter(this.ctype, System.out, 0);
        if (!this.readHeader()) {
            throw new ClassFormatError("invalid magic number");
        }
        this.readConstants();
        this.readClassInfo();
        this.readFields();
        this.readMethods();
        this.readAttributes(this.ctype);
        this.writer.printClassInfo();
        this.writer.printFields();
        this.writer.printMethods();
        this.printAttributes();
        this.writer.flush();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            dump.usage();
        }
        String filename = args[0];
        try {
            FileInputStream inp = new FileInputStream(filename);
            new dump(inp);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + filename + " not found");
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(-1);
        }
    }

    public void printAttributes() {
        ClassType attrs = this.ctype;
        this.writer.println();
        this.writer.print("Attributes (count: ");
        this.writer.print(Attribute.count(attrs));
        this.writer.println("):");
        this.writer.printAttributes(attrs);
    }

    public Attribute readAttribute(String name, int length, AttrContainer container) throws IOException {
        return super.readAttribute(name, length, container);
    }

    public ConstantPool readConstants() throws IOException {
        this.ctype.constants = super.readConstants();
        if (this.writer.printConstants) {
            this.writer.printConstantPool();
        }
        return this.ctype.constants;
    }

    public static void usage() {
        System.err.println("Usage: foo.class");
        System.exit(-1);
    }
}

