/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import java.io.IOException;
import java.io.Writer;

class BufferedPort
extends Writer {
    protected Writer out;
    char[] buffer;
    int bufStartPos = 0;
    int bufWritePos = 0;
    int startColumn = 0;

    BufferedPort(Writer writer, int n) {
        this.out = writer;
        this.buffer = new char[n];
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.flushLocal();
            this.out.close();
            this.out = null;
        }
        this.buffer = null;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flushLocal();
        this.out.flush();
    }

    void flushLocal() throws IOException {
        block2: {
            char c;
            if (this.out == null) {
                char[] cArray = new char[2 * this.buffer.length];
                System.arraycopy(this.buffer, 0, cArray, 0, this.bufWritePos);
                this.buffer = cArray;
                return;
            }
            int n = this.bufWritePos;
            do {
                if (--n >= this.bufStartPos) continue;
                this.startColumn += this.bufWritePos - this.bufStartPos;
                break block2;
            } while ((c = this.buffer[n]) != '\n' && c != '\r');
            this.startColumn = this.bufWritePos - n;
        }
        this.out.write(this.buffer, this.bufStartPos, this.bufWritePos - this.bufStartPos);
        this.bufWritePos = 0;
        this.bufStartPos = 0;
    }

    public int getColumnNumber() {
        char c;
        int n = this.bufWritePos;
        do {
            if (--n >= this.bufStartPos) continue;
            return this.startColumn + this.bufWritePos - this.bufStartPos;
        } while ((c = this.buffer[n]) != '\n' && c != '\r');
        return this.bufWritePos - n;
    }

    public void write(int n) throws IOException {
        if (this.bufWritePos >= this.buffer.length) {
            this.flushLocal();
        }
        this.buffer[this.bufWritePos++] = (char)n;
    }

    public void write(String string, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            if (this.bufWritePos + n2 > this.buffer.length) {
                this.flushLocal();
            }
            if ((n3 = this.buffer.length - this.bufWritePos) > n2) {
                n3 = n2;
            }
            if (n3 == 0) {
                throw new Error("can't do anything! buflen:" + this.buffer.length + " bwpos:" + this.bufWritePos);
            }
            string.getChars(n, n + n3, this.buffer, this.bufWritePos);
            this.bufWritePos += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            if (this.bufWritePos + n2 > this.buffer.length) {
                this.flushLocal();
            }
            if ((n3 = this.buffer.length - this.bufWritePos) > n2) {
                n3 = n2;
            }
            if (n3 == 0) {
                throw new Error("can't do anything!");
            }
            System.arraycopy(cArray, n, this.buffer, this.bufWritePos, n3);
            this.bufWritePos += n3;
            n += n3;
            n2 -= n3;
        }
    }
}

