/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import java.io.PrintWriter;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;
    Method makeBindingMethod = null;

    public LetExp(Expression[] expressionArray) {
        this.inits = expressionArray;
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Type type;
            declaration.allocateVariable(codeAttr);
            Target target2 = !declaration.needsInit() ? Target.Ignore : ((type = declaration.getType()) == Type.pointer_type ? Target.pushObject : new StackTarget(type));
            this.inits[n].compile(compilation, target2);
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.enterScope(this.scope);
        LetExp.store_rest(compilation, this.firstDecl());
        this.body.compileWithPosition(compilation, target);
        codeAttr.popScope();
    }

    public Expression getBody() {
        return this.body;
    }

    public final Type getType() {
        return this.body.getType();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%let (");
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (declaration != null) {
            if (n > 0) {
                printWriter.print(" ");
            }
            printWriter.print("(");
            printWriter.print(declaration.getName());
            printWriter.print(" ");
            if (this.inits[n] == null) {
                printWriter.print("<null>");
            } else {
                this.inits[n].print(printWriter);
            }
            ++n;
            printWriter.print(")");
            declaration = declaration.nextDecl();
        }
        printWriter.print(") ");
        this.body.print(printWriter);
        printWriter.print(")");
    }

    public void setBody(Expression expression) {
        this.body = expression;
    }

    static void store_rest(Compilation compilation, Declaration declaration) {
        if (declaration != null) {
            LetExp.store_rest(compilation, declaration.nextDecl());
            if (declaration.needsInit()) {
                declaration.initBinding(compilation);
            }
        }
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkLetExp(this);
    }
}

